/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.selector;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.client.DirectDruidClient;
import org.apache.hive.druid.org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class ConnectionCountServerSelectorStrategy
implements ServerSelectorStrategy {
    private static final Comparator<QueryableDruidServer> COMPARATOR = Comparator.comparingInt(s -> ((DirectDruidClient)s.getQueryRunner()).getNumOpenConnections());

    @Override
    public QueryableDruidServer pick(Set<QueryableDruidServer> servers, DataSegment segment) {
        return Collections.min(servers, COMPARATOR);
    }

    @Override
    public List<QueryableDruidServer> pick(Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
        if (servers.size() <= numServersToPick) {
            return ImmutableList.copyOf(servers);
        }
        return Ordering.from(COMPARATOR).leastOf(servers, numServersToPick);
    }
}

