/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.indexing;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.client.indexing.ClientCompactQuery;
import org.apache.hive.druid.org.apache.druid.client.indexing.ClientCompactQueryTuningConfig;
import org.apache.hive.druid.org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.hive.druid.org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.hive.druid.org.apache.druid.client.indexing.ClientKillQuery;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingService;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.hive.druid.org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.hive.druid.org.apache.druid.client.indexing.TaskStatus;
import org.apache.hive.druid.org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.hive.druid.org.apache.druid.discovery.DruidLeaderClient;
import org.apache.hive.druid.org.apache.druid.indexer.TaskStatusPlus;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class HttpIndexingServiceClient
implements IndexingServiceClient {
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public HttpIndexingServiceClient(ObjectMapper jsonMapper, @IndexingService DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    @Override
    public void killSegments(String dataSource, Interval interval) {
        this.runTask(new ClientKillQuery(dataSource, interval));
    }

    @Override
    public String compactSegments(List<DataSegment> segments, int compactionTaskPriority, ClientCompactQueryTuningConfig tuningConfig, @Nullable Map<String, Object> context) {
        Preconditions.checkArgument(!segments.isEmpty(), "Expect non-empty segments to compact");
        String dataSource = segments.get(0).getDataSource();
        Preconditions.checkArgument(segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), "Segments must have the same dataSource");
        context = context == null ? new HashMap<String, Object>() : context;
        context.put("priority", compactionTaskPriority);
        return this.runTask(new ClientCompactQuery(dataSource, new ClientCompactionIOConfig(ClientCompactionIntervalSpec.fromSegments(segments)), tuningConfig, context));
    }

    @Override
    public String runTask(Object taskObject) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/task").setContent("application/json", this.jsonMapper.writeValueAsBytes(taskObject)));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                if (!Strings.isNullOrEmpty(response.getContent())) {
                    throw new ISE("Failed to post task[%s] with error[%s].", taskObject, response.getContent());
                }
                throw new ISE("Failed to post task[%s]. Please check overlord log", taskObject);
            }
            Map<String, Object> resultMap = this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String taskId = (String)resultMap.get("task");
            return Preconditions.checkNotNull(taskId, "Null task id for task[%s]", taskObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String killTask(String taskId) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, StringUtils.format("/druid/indexer/v1/task/%s/shutdown", StringUtils.urlEncode(taskId))));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Failed to kill task[%s]", taskId);
            }
            Map<String, Object> resultMap = this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String killedTaskId = (String)resultMap.get("task");
            Preconditions.checkNotNull(killedTaskId, "Null task id returned for task[%s]", taskId);
            Preconditions.checkState(taskId.equals(killedTaskId), "Requested to kill task[%s], but another task[%s] was killed!", taskId, killedTaskId);
            return killedTaskId;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getTotalWorkerCapacity() {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/workers").setHeader("Content-Type", "application/json"));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while getting available cluster capacity. status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            Collection<IndexingWorkerInfo> workers = this.jsonMapper.readValue(response.getContent(), new TypeReference<Collection<IndexingWorkerInfo>>(){});
            return workers.stream().mapToInt(workerInfo -> workerInfo.getWorker().getCapacity()).sum();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<TaskStatusPlus> getActiveTasks() {
        ArrayList<TaskStatusPlus> tasks = new ArrayList<TaskStatusPlus>();
        HashSet<String> taskIdsSeen = new HashSet<String>();
        Iterable<TaskStatusPlus> activeTasks = Iterables.concat(this.getTasks("waitingTasks"), this.getTasks("pendingTasks"), this.getTasks("runningTasks"));
        for (TaskStatusPlus task : activeTasks) {
            if (!taskIdsSeen.add(task.getId())) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private List<TaskStatusPlus> getTasks(String endpointSuffix) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/indexer/v1/%s", endpointSuffix)));
            if (!responseHolder.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching the status of the last complete task", new Object[0]);
            }
            return this.jsonMapper.readValue(responseHolder.getContent(), new TypeReference<List<TaskStatusPlus>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TaskStatusResponse getTaskStatus(String taskId) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/indexer/v1/task/%s/status", StringUtils.urlEncode(taskId))));
            return this.jsonMapper.readValue(responseHolder.getContent(), new TypeReference<TaskStatusResponse>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, TaskStatus> getTaskStatuses(Set<String> taskIds) throws InterruptedException {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/taskStatus").setContent("application/json", this.jsonMapper.writeValueAsBytes(taskIds)));
            return this.jsonMapper.readValue(responseHolder.getContent(), new TypeReference<Map<String, TaskStatus>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public TaskStatusPlus getLastCompleteTask() {
        List<TaskStatusPlus> completeTaskStatuses = this.getTasks("completeTasks?n=1");
        return completeTaskStatuses.isEmpty() ? null : completeTaskStatuses.get(0);
    }

    @Override
    public TaskPayloadResponse getTaskPayload(String taskId) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/indexer/v1/task/%s", StringUtils.urlEncode(taskId))));
            return this.jsonMapper.readValue(responseHolder.getContent(), new TypeReference<TaskPayloadResponse>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int killPendingSegments(String dataSource, DateTime end) {
        String endPoint = StringUtils.format("/druid/indexer/v1/pendingSegments/%s?interval=%s", StringUtils.urlEncode(dataSource), new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)end));
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.DELETE, endPoint));
            if (!responseHolder.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while killing pendingSegments of dataSource[%s] created until [%s]", dataSource, end);
            }
            Map<String, Object> resultMap = this.jsonMapper.readValue(responseHolder.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object numDeletedObject = resultMap.get("numDeleted");
            return (Integer)Preconditions.checkNotNull(numDeletedObject, "numDeletedObject");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

