/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.coordinator;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.org.apache.druid.client.coordinator.Coordinator;
import org.apache.hive.druid.org.apache.druid.discovery.DruidLeaderClient;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorClient {
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public CoordinatorClient(ObjectMapper jsonMapper, @Coordinator DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    @Nullable
    public Boolean isHandOffComplete(String dataSource, SegmentDescriptor descriptor) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/coordinator/v1/datasources/%s/handoffComplete?interval=%s&partitionNumber=%d&version=%s", StringUtils.urlEncode(dataSource), descriptor.getInterval(), descriptor.getPartitionNumber(), descriptor.getVersion())));
            if (response.getStatus().equals(HttpResponseStatus.NOT_FOUND)) {
                return null;
            }
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching serverView status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            return this.jsonMapper.readValue(response.getContent(), new TypeReference<Boolean>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ImmutableSegmentLoadInfo> fetchServerView(String dataSource, Interval interval, boolean incompleteOk) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/coordinator/v1/datasources/%s/intervals/%s/serverview?partial=%s", StringUtils.urlEncode(dataSource), interval.toString().replace('/', '_'), incompleteOk)));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching serverView status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            return this.jsonMapper.readValue(response.getContent(), new TypeReference<List<ImmutableSegmentLoadInfo>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<DataSegment> getDatabaseSegmentDataSourceSegments(String dataSource, List<Interval> intervals) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, StringUtils.format("/druid/coordinator/v1/metadata/datasources/%s/segments?full", StringUtils.urlEncode(dataSource))).setContent("application/json", this.jsonMapper.writeValueAsBytes(intervals)));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching database segment data source segments status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            return this.jsonMapper.readValue(response.getContent(), new TypeReference<List<DataSegment>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataSegment getDatabaseSegmentDataSourceSegment(String dataSource, String segmentId) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/coordinator/v1/metadata/datasources/%s/segments/%s", StringUtils.urlEncode(dataSource), StringUtils.urlEncode(segmentId))));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching database segment data source segment status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            return this.jsonMapper.readValue(response.getContent(), new TypeReference<DataSegment>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

