/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;

public class JsonParserIterator<T>
implements Iterator<T>,
Closeable {
    private static final Logger LOG = new Logger(JsonParserIterator.class);
    private JsonParser jp;
    private ObjectCodec objectCodec;
    private final JavaType typeRef;
    private final Future<InputStream> future;
    private final String url;
    private final String host;
    private final ObjectMapper objectMapper;
    private final BytesAccumulatingResponseHandler responseHandler;
    private final boolean hasTimeout;
    private final long timeoutAt;
    private final String queryId;

    public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url, @Nullable Query<T> query, String host, ObjectMapper objectMapper, BytesAccumulatingResponseHandler responseHandler) {
        this.typeRef = typeRef;
        this.future = future;
        this.url = url;
        if (query != null) {
            this.timeoutAt = query.getContextValue("queryFailTime", -1L);
            this.queryId = query.getId();
        } else {
            this.timeoutAt = -1L;
            this.queryId = null;
        }
        this.jp = null;
        this.host = host;
        this.objectMapper = objectMapper;
        this.responseHandler = responseHandler;
        this.hasTimeout = this.timeoutAt > -1L;
    }

    @Override
    public boolean hasNext() {
        this.init();
        if (this.jp.isClosed()) {
            return false;
        }
        if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
            CloseQuietly.close(this.jp);
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        this.init();
        try {
            Object retVal = this.objectCodec.readValue(this.jp, this.typeRef);
            this.jp.nextToken();
            return retVal;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void init() {
        if (this.jp == null) {
            try {
                InputStream is;
                long timeLeftMillis = this.timeoutAt - System.currentTimeMillis();
                if (this.hasTimeout && timeLeftMillis < 1L) {
                    throw new TimeoutException(StringUtils.format("url[%s] timed out", this.url));
                }
                InputStream inputStream = is = this.hasTimeout ? this.future.get(timeLeftMillis, TimeUnit.MILLISECONDS) : this.future.get();
                if (this.responseHandler != null && this.responseHandler.getStatus() != 200) {
                    this.interruptQuery(new RE("Unexpected response status [%s] description [%s] from request url[%s]", this.responseHandler.getStatus(), this.responseHandler.getDescription(), this.url));
                }
                if (is != null) {
                    this.jp = this.objectMapper.getFactory().createParser(is);
                } else {
                    this.interruptQuery(new ResourceLimitExceededException("url[%s] timed out or max bytes limit reached.", this.url));
                }
                JsonToken nextToken = this.jp.nextToken();
                if (nextToken == JsonToken.START_ARRAY) {
                    this.jp.nextToken();
                    this.objectCodec = this.jp.getCodec();
                } else if (nextToken == JsonToken.START_OBJECT) {
                    this.interruptQuery(this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class));
                } else {
                    this.interruptQuery(new IAE("Next token wasn't a START_ARRAY, was[%s] from url[%s]", new Object[]{this.jp.getCurrentToken(), this.url}));
                }
            }
            catch (IOException | InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
                this.interruptQuery(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jp != null) {
            this.jp.close();
        }
    }

    private void interruptQuery(Exception cause) {
        LOG.warn(cause, "Query [%s] to host [%s] interrupted", this.queryId, this.host);
        throw new QueryInterruptedException(cause, this.host);
    }
}

