/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.io.InputStream;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBufferInputStream;

public class InputStreamHolder {
    private final InputStream stream;
    private final long chunkNum;
    private final long length;

    public InputStreamHolder(InputStream stream, long chunkNum, long length) {
        this.stream = stream;
        this.chunkNum = chunkNum;
        this.length = length;
    }

    public static InputStreamHolder fromStream(InputStream stream, long chunkNum, long length) {
        return new InputStreamHolder(stream, chunkNum, length);
    }

    public static InputStreamHolder fromChannelBuffer(ChannelBuffer buffer, long chunkNum) {
        int length = buffer.readableBytes();
        return new InputStreamHolder(new ChannelBufferInputStream(buffer), chunkNum, length);
    }

    public InputStream getStream() {
        return this.stream;
    }

    public long getChunkNum() {
        return this.chunkNum;
    }

    public long getLength() {
        return this.length;
    }
}

