/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.InventoryView;
import org.apache.hive.druid.org.apache.druid.client.SegmentLoadInfo;
import org.apache.hive.druid.org.apache.druid.client.ServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.ServerView;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;

@ManageLifecycle
public class CoordinatorServerView
implements InventoryView {
    private static final Logger log = new Logger(CoordinatorServerView.class);
    private final Object lock = new Object();
    private final Map<SegmentId, SegmentLoadInfo> segmentLoadInfos;
    private final Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines;
    private final ServerInventoryView baseView;
    private final CoordinatorSegmentWatcherConfig segmentWatcherConfig;
    private final CountDownLatch initialized = new CountDownLatch(1);

    @Inject
    public CoordinatorServerView(ServerInventoryView baseView, CoordinatorSegmentWatcherConfig segmentWatcherConfig) {
        this.baseView = baseView;
        this.segmentWatcherConfig = segmentWatcherConfig;
        this.segmentLoadInfos = new HashMap<SegmentId, SegmentLoadInfo>();
        this.timelines = new HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>>();
        ExecutorService exec = Execs.singleThreaded("CoordinatorServerView-%s");
        baseView.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                CoordinatorServerView.this.serverAddedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CoordinatorServerView.this.serverRemovedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                CoordinatorServerView.this.initialized.countDown();
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        baseView.registerServerRemovedCallback(exec, new ServerView.ServerRemovedCallback(){

            @Override
            public ServerView.CallbackAction serverRemoved(DruidServer server) {
                CoordinatorServerView.this.removeServer(server);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    @LifecycleStart
    public void start() throws InterruptedException {
        if (this.segmentWatcherConfig.isAwaitInitializationOnStart()) {
            long startMillis = System.currentTimeMillis();
            log.info("%s waiting for initialization.", this.getClass().getSimpleName());
            this.initialized.await();
            log.info("%s initialized in [%,d] ms.", this.getClass().getSimpleName(), System.currentTimeMillis() - startMillis);
        }
    }

    private void removeServer(DruidServer server) {
        for (DataSegment segment : server.iterateAllSegments()) {
            this.serverRemovedSegment(server.getMetadata(), segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverAddedSegment(DruidServerMetadata server, DataSegment segment) {
        SegmentId segmentId = segment.getId();
        Object object = this.lock;
        synchronized (object) {
            log.debug("Adding segment[%s] for server[%s]", segment, server);
            SegmentLoadInfo segmentLoadInfo = this.segmentLoadInfos.get(segmentId);
            if (segmentLoadInfo == null) {
                segmentLoadInfo = new SegmentLoadInfo(segment);
                VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.timelines.get(segment.getDataSource());
                if (timeline == null) {
                    timeline = new VersionedIntervalTimeline(Ordering.natural());
                    this.timelines.put(segment.getDataSource(), timeline);
                }
                timeline.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segmentLoadInfo));
                this.segmentLoadInfos.put(segmentId, segmentLoadInfo);
            }
            segmentLoadInfo.addServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverRemovedSegment(DruidServerMetadata server, DataSegment segment) {
        SegmentId segmentId = segment.getId();
        Object object = this.lock;
        synchronized (object) {
            log.debug("Removing segment[%s] from server[%s].", segmentId, server);
            SegmentLoadInfo segmentLoadInfo = this.segmentLoadInfos.get(segmentId);
            if (segmentLoadInfo == null) {
                log.warn("Told to remove non-existant segment[%s]", segmentId);
                return;
            }
            segmentLoadInfo.removeServer(server);
            if (segmentLoadInfo.isEmpty()) {
                VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.timelines.get(segment.getDataSource());
                this.segmentLoadInfos.remove(segmentId);
                PartitionChunk<SegmentLoadInfo> removedPartition = timeline.remove(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(new SegmentLoadInfo(segment)));
                if (removedPartition == null) {
                    log.warn("Asked to remove timeline entry[interval: %s, version: %s] that doesn't exist", segment.getInterval(), segment.getVersion());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedIntervalTimeline<String, SegmentLoadInfo> getTimeline(DataSource dataSource) {
        String table = Iterables.getOnlyElement(dataSource.getNames());
        Object object = this.lock;
        synchronized (object) {
            return this.timelines.get(table);
        }
    }

    @Override
    public DruidServer getInventoryValue(String serverKey) {
        return this.baseView.getInventoryValue(serverKey);
    }

    @Override
    public Collection<DruidServer> getInventory() {
        return this.baseView.getInventory();
    }

    @Override
    public boolean isStarted() {
        return this.baseView.isStarted();
    }

    @Override
    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        return this.baseView.isSegmentLoadedByServer(serverKey, segment);
    }
}

