/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.validate;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWithItem;
import org.apache.hive.druid.org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

class WithItemNamespace
extends AbstractNamespace {
    private final SqlWithItem withItem;

    WithItemNamespace(SqlValidatorImpl validator, SqlWithItem withItem, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.withItem = withItem;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        SqlValidatorNamespace childNs = this.validator.getNamespaceOrThrow(this.withItem.query);
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        SqlNodeList columnList = this.withItem.columnList;
        if (columnList == null) {
            return rowType;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        Pair.forEach(SqlIdentifier.simpleNames(columnList), rowType.getFieldList(), (name, field) -> builder.add((String)name, field.getType()));
        return builder.build();
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.withItem;
    }

    @Override
    public String translate(String name) {
        if (this.withItem.columnList == null) {
            return name;
        }
        RelDataType underlyingRowType = this.validator.getValidatedNodeType(this.withItem.query);
        int i = 0;
        for (RelDataTypeField field : this.getRowType().getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

