/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.util;

import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialect;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class SqlString {
    private final String sql;
    private SqlDialect dialect;
    private @Nullable ImmutableList<Integer> dynamicParameters;

    public SqlString(SqlDialect dialect, String sql) {
        this(dialect, sql, ImmutableList.of());
    }

    public SqlString(SqlDialect dialect, String sql, @Nullable ImmutableList<Integer> dynamicParameters) {
        this.dialect = dialect;
        this.sql = sql;
        this.dynamicParameters = dynamicParameters;
        assert (sql != null) : "sql must be NOT null";
        assert (dialect != null) : "dialect must be NOT null";
    }

    public int hashCode() {
        return this.sql.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof SqlString && this.sql.equals(((SqlString)obj).sql);
    }

    public String toString() {
        return this.sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Pure
    public @Nullable ImmutableList<Integer> getDynamicParameters() {
        return this.dynamicParameters;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }
}

