/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import java.util.function.Predicate;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class IntervalOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    private final Predicate<SqlIntervalQualifier> predicate;

    IntervalOperandTypeChecker(Predicate<SqlIntervalQualifier> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        SqlNode operand = callBinding.operand(iFormalOperand);
        if (operand instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier interval = (SqlIntervalQualifier)operand;
            if (this.predicate.test(interval)) {
                return true;
            }
            if (throwOnFailure) {
                String name = Util.first(interval.timeFrameName, interval.timeUnitRange.name());
                throw callBinding.getValidator().newValidationError(operand, Static.RESOURCE.invalidTimeFrame(name));
            }
        }
        return false;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<INTERVAL>";
    }
}

