/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.Arrays;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlNonNullableAccessors;

class SqlItemOperator
extends SqlSpecialOperator {
    private static final SqlSingleOperandTypeChecker ARRAY_OR_MAP = OperandTypes.family(SqlTypeFamily.ARRAY).or(OperandTypes.family(SqlTypeFamily.MAP)).or(OperandTypes.family(SqlTypeFamily.ANY));

    SqlItemOperator() {
        super("ITEM", SqlKind.ITEM, 100, true, null, null, null);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult(ordinal - 1, ordinal + 2, this.createCall(SqlParserPos.sum(Arrays.asList(Objects.requireNonNull(left, "left").getParserPosition(), Objects.requireNonNull(right, "right").getParserPosition(), list.pos(ordinal))), left, right));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
        SqlWriter.Frame frame = writer.startList("[", "]");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (!ARRAY_OR_MAP.checkSingleOperandType(callBinding, left, 0, throwOnFailure)) {
            return false;
        }
        SqlSingleOperandTypeChecker checker = SqlItemOperator.getChecker(callBinding);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private static SqlSingleOperandTypeChecker getChecker(SqlCallBinding callBinding) {
        RelDataType operandType = callBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return OperandTypes.family(SqlTypeFamily.INTEGER);
            }
            case MAP: {
                RelDataType keyType = Objects.requireNonNull(operandType.getKeyType(), "operandType.getKeyType()");
                SqlTypeName sqlTypeName = keyType.getSqlTypeName();
                return OperandTypes.family(Objects.requireNonNull(sqlTypeName.getFamily(), () -> "keyType.getSqlTypeName().getFamily() null, type is " + (Object)((Object)sqlTypeName)));
            }
            case ROW: 
            case ANY: 
            case DYNAMIC_STAR: {
                return OperandTypes.family(SqlTypeFamily.INTEGER).or(OperandTypes.family(SqlTypeFamily.CHARACTER));
            }
        }
        throw callBinding.newValidationSignatureError();
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<ARRAY>[<INTEGER>]\n<MAP>[<ANY>]\n<ROW>[<CHARACTER>|<INTEGER>]";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType operandType = opBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return typeFactory.createTypeWithNullability(NonNullableAccessors.getComponentTypeOrThrow(operandType), true);
            }
            case MAP: {
                return typeFactory.createTypeWithNullability(Objects.requireNonNull(operandType.getValueType(), () -> "operandType.getValueType() is null for " + operandType), true);
            }
            case ROW: {
                RelDataType fieldType;
                RelDataType indexType = opBinding.getOperandType(1);
                if (SqlTypeUtil.isString(indexType)) {
                    String fieldName = SqlNonNullableAccessors.getOperandLiteralValueOrThrow(opBinding, 1, String.class);
                    RelDataTypeField field = operandType.getField(fieldName, false, false);
                    if (field == null) {
                        throw new AssertionError((Object)("Cannot infer type of field '" + fieldName + "' within ROW type: " + operandType));
                    }
                    fieldType = field.getType();
                } else if (SqlTypeUtil.isIntType(indexType)) {
                    Integer index = opBinding.getOperandLiteralValue(1, Integer.class);
                    if (index == null || index < 1 || index > operandType.getFieldCount()) {
                        throw new AssertionError((Object)("Cannot infer type of field at position " + index + " within ROW type: " + operandType));
                    }
                    fieldType = operandType.getFieldList().get(index - 1).getType();
                } else {
                    throw new AssertionError((Object)("Unsupported field identifier type: '" + indexType + "'"));
                }
                if (fieldType != null && operandType.isNullable()) {
                    fieldType = typeFactory.createTypeWithNullability(fieldType, true);
                }
                return fieldType;
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }
        throw new AssertionError();
    }
}

