/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.advise;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Linq4j;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Types;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.schema.FunctionParameter;
import org.apache.hive.druid.org.apache.calcite.schema.ImplementableFunction;
import org.apache.hive.druid.org.apache.calcite.schema.TableFunction;
import org.apache.hive.druid.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.hive.druid.org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.hive.druid.org.apache.calcite.sql.advise.SqlAdvisorHint;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlAdvisorGetHintsFunction
implements TableFunction,
ImplementableFunction {
    private static final Expression ADVISOR = Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant(DataContext.Variable.SQL_ADVISOR.camelName)), SqlAdvisor.class);
    private static final Method GET_COMPLETION_HINTS = Types.lookupMethod(SqlAdvisorGetHintsFunction.class, "getCompletionHints", SqlAdvisor.class, String.class, Integer.TYPE);
    private static final CallImplementor IMPLEMENTOR = RexImpTable.createImplementor((translator, call, operands) -> Expressions.call(GET_COMPLETION_HINTS, Iterables.concat(Collections.singleton(ADVISOR), operands)), NullPolicy.ANY, false);
    private static final List<FunctionParameter> PARAMETERS = ReflectiveFunctionBase.builder().add(String.class, "sql").add(Integer.TYPE, "pos").build();

    @Override
    public CallImplementor getImplementor() {
        return IMPLEMENTOR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<? extends @Nullable Object> arguments) {
        return typeFactory.createJavaType(SqlAdvisorHint.class);
    }

    @Override
    public Type getElementType(List<? extends @Nullable Object> arguments) {
        return SqlAdvisorHint.class;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    public static Enumerable<SqlAdvisorHint> getCompletionHints(SqlAdvisor advisor, String sql, int pos) {
        String[] replaced = new String[1];
        List<SqlMoniker> hints = advisor.getCompletionHints(sql, pos, replaced);
        ArrayList<SqlAdvisorHint> res = new ArrayList<SqlAdvisorHint>(hints.size() + 1);
        res.add(new SqlAdvisorHint(replaced[0], null, "MATCH"));
        for (SqlMoniker hint : hints) {
            res.add(new SqlAdvisorHint(hint));
        }
        return Linq4j.asEnumerable(res).asQueryable();
    }
}

