/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class SqlWithinDistinctOperator
extends SqlBinaryOperator {
    public SqlWithinDistinctOperator() {
        super("WITHIN DISTINCT", SqlKind.WITHIN_DISTINCT, 100, true, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.keyword("WITHIN DISTINCT");
        SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.GROUP_BY_LIST, "(", ")");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(orderFrame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        if (!flat.aggregateCall.getOperator().isAggregator()) {
            throw validator.newValidationError(call, Static.RESOURCE.withinDistinctNotAllowed(flat.aggregateCall.getOperator().getName()));
        }
        for (SqlNode order : Objects.requireNonNull(flat.distinctList)) {
            Objects.requireNonNull(validator.deriveType(scope, order));
        }
        validator.validateAggregateParams(flat.aggregateCall, flat.filter, flat.distinctList, flat.orderList, scope);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.validateOperands(validator, scope, call);
    }
}

