/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlTableFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlUtil;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlWindowTableFunction
extends SqlFunction
implements SqlTableFunction {
    protected static final String PARAM_DATA = "DATA";
    protected static final String PARAM_TIMECOL = "TIMECOL";
    protected static final String PARAM_SIZE = "SIZE";
    protected static final String PARAM_OFFSET = "OFFSET";
    protected static final String PARAM_KEY = "KEY";
    protected static final String PARAM_SLIDE = "SLIDE";
    public static final SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = SqlWindowTableFunction::inferRowType;

    public SqlWindowTableFunction(String name, SqlOperandMetadata operandMetadata) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, operandMetadata, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public @Nullable SqlOperandMetadata getOperandTypeChecker() {
        return (SqlOperandMetadata)super.getOperandTypeChecker();
    }

    @Override
    public SqlReturnTypeInference getRowTypeInference() {
        return ARG0_TABLE_FUNCTION_WINDOWING;
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }

    private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
        RelDataType inputRowType = opBinding.getOperandType(0);
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return ((RelDataTypeFactory.FieldInfoBuilder)typeFactory.builder().kind(inputRowType.getStructKind()).addAll(inputRowType.getFieldList())).add("window_start", SqlTypeName.TIMESTAMP, 3).add("window_end", SqlTypeName.TIMESTAMP, 3).build();
    }

    protected static abstract class AbstractOperandMetadata
    implements SqlOperandMetadata {
        final List<String> paramNames;
        final int mandatoryParamCount;

        AbstractOperandMetadata(List<String> paramNames, int mandatoryParamCount) {
            this.paramNames = ImmutableList.copyOf(paramNames);
            this.mandatoryParamCount = mandatoryParamCount;
            Preconditions.checkArgument(mandatoryParamCount >= 0 && mandatoryParamCount <= paramNames.size());
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.between(this.mandatoryParamCount, this.paramNames.size());
        }

        @Override
        public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
            return Collections.nCopies(this.paramNames.size(), typeFactory.createSqlType(SqlTypeName.ANY));
        }

        @Override
        public List<String> paramNames() {
            return this.paramNames;
        }

        @Override
        public boolean isOptional(int i) {
            return i > this.getOperandCountRange().getMin() && i <= this.getOperandCountRange().getMax();
        }

        boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }

        boolean checkTableAndDescriptorOperands(SqlCallBinding callBinding, int descriptorCount) {
            SqlNode operand0 = callBinding.operand(0);
            SqlValidator validator = callBinding.getValidator();
            RelDataType type = validator.getValidatedNodeType(operand0);
            if (type.getSqlTypeName() != SqlTypeName.ROW) {
                return false;
            }
            for (int i = 1; i < descriptorCount + 1; ++i) {
                SqlNode operand = callBinding.operand(i);
                if (operand.getKind() != SqlKind.DESCRIPTOR) {
                    return false;
                }
                this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand).getOperandList());
            }
            return true;
        }

        boolean checkTimeColumnDescriptorOperand(SqlCallBinding callBinding, int pos) {
            SqlValidator validator = callBinding.getValidator();
            SqlNode operand0 = callBinding.operand(0);
            RelDataType type = validator.getValidatedNodeType(operand0);
            List<SqlNode> operands = ((SqlCall)callBinding.operand(pos)).getOperandList();
            SqlIdentifier identifier = (SqlIdentifier)operands.get(0);
            String columnName = identifier.getSimple();
            SqlNameMatcher matcher = validator.getCatalogReader().nameMatcher();
            for (RelDataTypeField field : type.getFieldList()) {
                if (!matcher.matches(field.getName(), columnName)) continue;
                return SqlTypeUtil.isTimestamp(field.getType());
            }
            return false;
        }

        boolean checkIntervalOperands(SqlCallBinding callBinding, int startPos) {
            SqlValidator validator = callBinding.getValidator();
            for (int i = startPos; i < callBinding.getOperandCount(); ++i) {
                RelDataType type = validator.getValidatedNodeType(callBinding.operand(i));
                if (SqlTypeUtil.isInterval(type)) continue;
                return false;
            }
            return true;
        }

        void validateColumnNames(SqlValidator validator, List<String> fieldNames, List<SqlNode> columnNames) {
            SqlNameMatcher matcher = validator.getCatalogReader().nameMatcher();
            Ord.forEach(SqlIdentifier.simpleNames(columnNames), (name, i) -> {
                if (matcher.indexOf((Iterable<String>)fieldNames, (String)name) < 0) {
                    SqlIdentifier columnName = (SqlIdentifier)columnNames.get(i);
                    throw SqlUtil.newContextException(columnName.getParserPosition(), Static.RESOURCE.unknownIdentifier((String)name));
                }
            });
        }
    }
}

