/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAlter;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlSetOption
extends SqlAlter {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SET_OPTION", SqlKind.SET_OPTION){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            SqlNode scopeNode = operands[0];
            return new SqlSetOption(pos, scopeNode == null ? null : scopeNode.toString(), (SqlIdentifier)operands[1], operands[2]);
        }
    };
    SqlIdentifier name;
    @Nullable SqlNode value;

    public SqlSetOption(SqlParserPos pos, @Nullable String scope, SqlIdentifier name, @Nullable SqlNode value) {
        super(pos, scope);
        this.scope = scope;
        this.name = name;
        this.value = value;
        assert (name != null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.SET_OPTION;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<@Nullable SqlNode> operandList = new ArrayList<SqlNode>();
        if (this.scope == null) {
            operandList.add(null);
        } else {
            operandList.add(new SqlIdentifier(this.scope, SqlParserPos.ZERO));
        }
        operandList.add(this.name);
        operandList.add(this.value);
        return ImmutableNullableList.copyOf(operandList);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                if (operand != null) {
                    this.scope = ((SqlIdentifier)operand).getSimple();
                    break;
                }
                this.scope = null;
                break;
            }
            case 1: {
                this.name = (SqlIdentifier)Objects.requireNonNull(operand, "name");
                break;
            }
            case 2: {
                this.value = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    protected void unparseAlterOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.value != null) {
            writer.keyword("SET");
        } else {
            writer.keyword("RESET");
        }
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.value != null) {
            writer.sep("=");
            this.value.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.value != null) {
            validator.validate(this.value);
        }
    }

    public SqlIdentifier getName() {
        return this.name;
    }

    public void setName(SqlIdentifier name) {
        this.name = name;
    }

    public @Nullable SqlNode getValue() {
        return this.value;
    }

    public void setValue(SqlNode value) {
        this.value = value;
    }
}

