/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOrderBy;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelectOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class SqlSelect
extends SqlCall {
    public static final int FROM_OPERAND = 2;
    public static final int WHERE_OPERAND = 3;
    public static final int HAVING_OPERAND = 5;
    SqlNodeList keywordList;
    SqlNodeList selectList;
    @Nullable SqlNode from;
    @Nullable SqlNode where;
    @Nullable SqlNodeList groupBy;
    @Nullable SqlNode having;
    SqlNodeList windowDecls;
    @Nullable SqlNodeList orderBy;
    @Nullable SqlNode offset;
    @Nullable SqlNode fetch;
    @Nullable SqlNodeList hints;

    public SqlSelect(SqlParserPos pos, @Nullable SqlNodeList keywordList, SqlNodeList selectList, @Nullable SqlNode from, @Nullable SqlNode where, @Nullable SqlNodeList groupBy, @Nullable SqlNode having, @Nullable SqlNodeList windowDecls, @Nullable SqlNodeList orderBy, @Nullable SqlNode offset, @Nullable SqlNode fetch, @Nullable SqlNodeList hints) {
        super(pos);
        this.keywordList = Objects.requireNonNull(keywordList != null ? keywordList : new SqlNodeList(pos));
        this.selectList = Objects.requireNonNull(selectList, "selectList");
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.windowDecls = Objects.requireNonNull(windowDecls != null ? windowDecls : new SqlNodeList(pos));
        this.orderBy = orderBy;
        this.offset = offset;
        this.fetch = fetch;
        this.hints = hints;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlSelectOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.SELECT;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.keywordList, this.selectList, this.from, this.where, this.groupBy, this.having, this.windowDecls, this.orderBy, new SqlNode[]{this.offset, this.fetch, this.hints});
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywordList = Objects.requireNonNull((SqlNodeList)operand);
                break;
            }
            case 1: {
                this.selectList = Objects.requireNonNull((SqlNodeList)operand);
                break;
            }
            case 2: {
                this.from = operand;
                break;
            }
            case 3: {
                this.where = operand;
                break;
            }
            case 4: {
                this.groupBy = (SqlNodeList)operand;
                break;
            }
            case 5: {
                this.having = operand;
                break;
            }
            case 6: {
                this.windowDecls = Objects.requireNonNull((SqlNodeList)operand);
                break;
            }
            case 7: {
                this.orderBy = (SqlNodeList)operand;
                break;
            }
            case 8: {
                this.offset = operand;
                break;
            }
            case 9: {
                this.fetch = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final boolean isDistinct() {
        return this.getModifierNode(SqlSelectKeyword.DISTINCT) != null;
    }

    public final @Nullable SqlNode getModifierNode(SqlSelectKeyword modifier) {
        for (SqlNode keyword : this.keywordList) {
            SqlSelectKeyword keyword2 = ((SqlLiteral)keyword).symbolValue(SqlSelectKeyword.class);
            if (keyword2 != modifier) continue;
            return keyword;
        }
        return null;
    }

    @Pure
    public final @Nullable SqlNode getFrom() {
        return this.from;
    }

    public void setFrom(@Nullable SqlNode from) {
        this.from = from;
    }

    @Pure
    public final @Nullable SqlNodeList getGroup() {
        return this.groupBy;
    }

    public void setGroupBy(@Nullable SqlNodeList groupBy) {
        this.groupBy = groupBy;
    }

    @Pure
    public final @Nullable SqlNode getHaving() {
        return this.having;
    }

    public void setHaving(@Nullable SqlNode having) {
        this.having = having;
    }

    @Pure
    public final SqlNodeList getSelectList() {
        return this.selectList;
    }

    public void setSelectList(SqlNodeList selectList) {
        this.selectList = selectList;
    }

    @Pure
    public final @Nullable SqlNode getWhere() {
        return this.where;
    }

    public void setWhere(@Nullable SqlNode whereClause) {
        this.where = whereClause;
    }

    public final SqlNodeList getWindowList() {
        return this.windowDecls;
    }

    @Pure
    public final @Nullable SqlNodeList getOrderList() {
        return this.orderBy;
    }

    public void setOrderBy(@Nullable SqlNodeList orderBy) {
        this.orderBy = orderBy;
    }

    @Pure
    public final @Nullable SqlNode getOffset() {
        return this.offset;
    }

    public void setOffset(@Nullable SqlNode offset) {
        this.offset = offset;
    }

    @Pure
    public final @Nullable SqlNode getFetch() {
        return this.fetch;
    }

    public void setFetch(@Nullable SqlNode fetch) {
        this.fetch = fetch;
    }

    public void setHints(@Nullable SqlNodeList hints) {
        this.hints = hints;
    }

    @Pure
    public @Nullable SqlNodeList getHints() {
        return this.hints;
    }

    @EnsuresNonNullIf(expression={"hints"}, result=true)
    public boolean hasHints() {
        return this.hints != null && this.hints.size() > 0;
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateQuery(this, scope, validator.getUnknownType());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (!writer.inQuery() || this.getFetch() != null && (leftPrec > SqlInternalOperators.FETCH.getLeftPrec() || rightPrec > SqlInternalOperators.FETCH.getLeftPrec()) || this.getOffset() != null && (leftPrec > SqlInternalOperators.OFFSET.getLeftPrec() || rightPrec > SqlInternalOperators.OFFSET.getLeftPrec()) || this.getOrderList() != null && (leftPrec > SqlOrderBy.OPERATOR.getLeftPrec() || rightPrec > SqlOrderBy.OPERATOR.getRightPrec())) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SUB_QUERY, "(", ")");
            writer.getDialect().unparseCall(writer, this, 0, 0);
            writer.endList(frame);
        } else {
            writer.getDialect().unparseCall(writer, this, leftPrec, rightPrec);
        }
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() != 0;
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public boolean isKeywordPresent(SqlSelectKeyword targetKeyWord) {
        return this.getModifierNode(targetKeyWord) != null;
    }
}

