/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rex;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.config.CalciteSystemProperty;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apiguardian.api.API;

public class RexNormalize {
    private RexNormalize() {
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    public static Pair<SqlOperator, List<RexNode>> normalize(SqlOperator operator, List<RexNode> operands) {
        Pair<SqlOperator, List<RexNode>> original = Pair.of(operator, operands);
        if (!RexNormalize.allowsNormalize() || operands.size() != 2) {
            return original;
        }
        RexNode operand0 = operands.get(0);
        RexNode operand1 = operands.get(1);
        SqlKind kind = operator.getKind();
        SqlKind reversedKind = kind.reverse();
        int x = reversedKind.compareTo(kind);
        if (x < 0) {
            return Pair.of(Objects.requireNonNull(operator.reverse()), ImmutableList.of(operand1, operand0));
        }
        if (x > 0) {
            return original;
        }
        if (!RexNormalize.isSymmetricalCall(operator, operand0, operand1)) {
            return original;
        }
        if (RexNormalize.reorderOperands(operand0, operand1) < 0) {
            return Pair.of(Objects.requireNonNull(operator.reverse()), ImmutableList.of(operand1, operand0));
        }
        return original;
    }

    public static int hashCode(SqlOperator operator, List<RexNode> operands) {
        if (!RexNormalize.allowsNormalize() || operands.size() != 2) {
            return Objects.hash(operator, operands);
        }
        SqlKind kind = operator.getKind();
        SqlKind reversedKind = kind.reverse();
        int x = reversedKind.compareTo(kind);
        if (x < 0) {
            return Objects.hash(Objects.requireNonNull(operator.reverse()), Arrays.asList(operands.get(1), operands.get(0)));
        }
        if (RexNormalize.isSymmetricalCall(operator, operands.get(0), operands.get(1))) {
            return Objects.hash(operator, RexNormalize.unorderedHash(operands));
        }
        return Objects.hash(operator, operands);
    }

    private static int reorderOperands(RexNode operand0, RexNode operand1) {
        int x = operand0.getKind().compareTo(operand1.getKind());
        return x != 0 ? x : operand1.hashCode() - operand0.hashCode();
    }

    private static boolean isSymmetricalCall(SqlOperator operator, RexNode operand0, RexNode operand1) {
        return operator.isSymmetrical() || SqlKind.SYMMETRICAL_SAME_ARG_TYPE.contains((Object)operator.getKind()) && SqlTypeUtil.equalSansNullability(operand0.getType(), operand1.getType());
    }

    private static int unorderedHash(List<?> xs) {
        int a = 0;
        int b = 0;
        int c = 1;
        for (Object x : xs) {
            int h = Objects.hashCode(x);
            a += h;
            b ^= h;
            if (h == 0) continue;
            c *= h;
        }
        return (a * 17 + b) * 17 + c;
    }

    private static boolean allowsNormalize() {
        return CalciteSystemProperty.ENABLE_REX_DIGEST_NORMALIZE.value();
    }
}

