/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.type;

import java.math.BigInteger;
import java.util.NavigableMap;
import java.util.Objects;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultimap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.rel.type.TimeFrame;
import org.apache.hive.druid.org.apache.calcite.rel.type.TimeFrames;
import org.apache.hive.druid.org.apache.calcite.util.NameMap;
import org.apache.hive.druid.org.apache.calcite.util.TimestampString;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimeFrameSet {
    final ImmutableMap<String, TimeFrames.TimeFrameImpl> map;
    final ImmutableMultimap<TimeFrames.TimeFrameImpl, TimeFrames.TimeFrameImpl> rollupMap;
    private final NameMap<TimeFrames.TimeFrameImpl> nameMap;

    TimeFrameSet(ImmutableMap<String, TimeFrames.TimeFrameImpl> map, ImmutableMultimap<TimeFrames.TimeFrameImpl, TimeFrames.TimeFrameImpl> rollupMap) {
        this.map = Objects.requireNonNull(map, "map");
        this.nameMap = NameMap.immutableCopyOf(map);
        this.rollupMap = Objects.requireNonNull(rollupMap, "rollupMap");
    }

    public static Builder builder() {
        return new TimeFrames.BuilderImpl();
    }

    public @Nullable TimeFrame getOpt(String name) {
        NavigableMap<String, TimeFrames.TimeFrameImpl> range = this.nameMap.range(name, false);
        @Nullable TimeFrame timeFrame = Iterables.getFirst(range.values(), null);
        while (timeFrame instanceof TimeFrames.AliasFrame) {
            timeFrame = ((TimeFrames.AliasFrame)timeFrame).frame;
        }
        return timeFrame;
    }

    public TimeFrame get(String name) {
        TimeFrame timeFrame = this.getOpt(name);
        if (timeFrame == null) {
            throw new IllegalArgumentException("unknown frame: " + name);
        }
        return timeFrame;
    }

    public TimeFrame get(TimeUnit timeUnit) {
        return this.get(timeUnit.name());
    }

    public int floorDate(int date, TimeFrame frame) {
        return this.floorCeilDate(date, frame, false);
    }

    public int ceilDate(int date, TimeFrame frame) {
        return this.floorCeilDate(date, frame, true);
    }

    private int floorCeilDate(int date, TimeFrame frame, boolean ceil) {
        TimeFrame dayFrame = this.get(TimeUnit.DAY);
        BigFraction perDay = frame.per(dayFrame);
        if (perDay != null && perDay.getNumerator().equals(BigInteger.ONE)) {
            int m = perDay.getDenominator().intValueExact();
            int mod = Math.floorMod(date - frame.dateEpoch(), m);
            return date - mod + (ceil ? m : 0);
        }
        TimeFrame monthFrame = this.get(TimeUnit.MONTH);
        BigFraction perMonth = frame.per(monthFrame);
        if (perMonth != null && perMonth.getNumerator().equals(BigInteger.ONE)) {
            int y2 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)date);
            int m2 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.MONTH, (long)date);
            int fullMonth = TimeFrames.fullMonth(y2, m2);
            int m = perMonth.getDenominator().intValueExact();
            int mod = Math.floorMod(fullMonth - frame.monthEpoch(), m);
            return TimeFrames.mdToUnixDate(fullMonth - mod + (ceil ? m : 0), 1);
        }
        TimeFrame isoYearFrame = this.get(TimeUnit.ISOYEAR);
        BigFraction perIsoYear = frame.per(isoYearFrame);
        if (perIsoYear != null && perIsoYear.getNumerator().equals(BigInteger.ONE)) {
            return TimeFrames.floorCeilIsoYear(date, ceil);
        }
        return date;
    }

    public long floorTimestamp(long ts, TimeFrame frame) {
        return this.floorCeilTimestamp(ts, frame, false);
    }

    public long ceilTimestamp(long ts, TimeFrame frame) {
        return this.floorCeilTimestamp(ts, frame, true);
    }

    private long floorCeilTimestamp(long ts, TimeFrame frame, boolean ceil) {
        TimeFrame millisecondFrame = this.get(TimeUnit.MILLISECOND);
        BigFraction perMillisecond = frame.per(millisecondFrame);
        if (perMillisecond != null && perMillisecond.getNumerator().equals(BigInteger.ONE)) {
            long m = perMillisecond.getDenominator().longValue();
            long mod = Math.floorMod(ts - frame.timestampEpoch(), m);
            return ts - mod + (ceil ? m : 0L);
        }
        TimeFrame monthFrame = this.get(TimeUnit.MONTH);
        BigFraction perMonth = frame.per(monthFrame);
        if (perMonth != null && perMonth.getNumerator().equals(BigInteger.ONE)) {
            long ts2 = this.floorTimestamp(ts, this.get(TimeUnit.DAY));
            int d2 = (int)(ts2 / 86400000L);
            int y2 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)d2);
            int m2 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.MONTH, (long)d2);
            int fullMonth = TimeFrames.fullMonth(y2, m2);
            int m = perMonth.getDenominator().intValueExact();
            int mod = Math.floorMod(fullMonth - frame.monthEpoch(), m);
            return TimeFrames.unixTimestamp(fullMonth - mod + (ceil ? m : 0), 1, 0, 0, 0);
        }
        TimeFrame isoYearFrame = this.get(TimeUnit.ISOYEAR);
        BigFraction perIsoYear = frame.per(isoYearFrame);
        if (perIsoYear != null && perIsoYear.getNumerator().equals(BigInteger.ONE)) {
            long ts2 = this.floorTimestamp(ts, this.get(TimeUnit.DAY));
            int d2 = (int)(ts2 / 86400000L);
            return (long)TimeFrames.floorCeilIsoYear(d2, ceil) * 86400000L;
        }
        return ts;
    }

    public @Nullable TimeUnit getUnit(TimeFrame timeFrame) {
        TimeUnit timeUnit = (TimeUnit)Util.enumVal(TimeUnit.class, timeFrame.name());
        if (timeUnit == null) {
            return null;
        }
        TimeFrame timeFrame1 = this.getOpt(timeUnit.name());
        return Objects.equals(timeFrame1, timeFrame) ? timeUnit : null;
    }

    public int addDate(int date, int interval, TimeFrame frame) {
        TimeFrame dayFrame = this.get(TimeUnit.DAY);
        BigFraction perDay = frame.per(dayFrame);
        if (perDay != null && perDay.getNumerator().equals(BigInteger.ONE)) {
            int m = perDay.getDenominator().intValueExact();
            return date + interval * m;
        }
        TimeFrame monthFrame = this.get(TimeUnit.MONTH);
        BigFraction perMonth = frame.per(monthFrame);
        if (perMonth != null && perMonth.getNumerator().equals(BigInteger.ONE)) {
            int m = perMonth.getDenominator().intValueExact();
            return DateTimeUtils.addMonths((int)date, (int)(interval * m));
        }
        return date;
    }

    public long addTimestamp(long timestamp, long interval, TimeFrame frame) {
        TimeFrame msFrame = this.get(TimeUnit.MILLISECOND);
        BigFraction perMilli = frame.per(msFrame);
        if (perMilli != null && perMilli.getNumerator().equals(BigInteger.ONE)) {
            long m = perMilli.getDenominator().longValueExact();
            return timestamp + interval * m;
        }
        TimeFrame monthFrame = this.get(TimeUnit.MONTH);
        BigFraction perMonth = frame.per(monthFrame);
        if (perMonth != null && perMonth.getNumerator().equals(BigInteger.ONE)) {
            long m = perMonth.getDenominator().longValueExact();
            return DateTimeUtils.addMonths((long)timestamp, (int)((int)(interval * m)));
        }
        return timestamp;
    }

    public int diffDate(int date, int date2, TimeFrame frame) {
        TimeFrame dayFrame = this.get(TimeUnit.DAY);
        BigFraction perDay = frame.per(dayFrame);
        if (perDay != null && perDay.getNumerator().equals(BigInteger.ONE)) {
            int m = perDay.getDenominator().intValueExact();
            int delta = date2 - date;
            return Math.floorDiv(delta, m);
        }
        TimeFrame monthFrame = this.get(TimeUnit.MONTH);
        BigFraction perMonth = frame.per(monthFrame);
        if (perMonth != null && perMonth.getNumerator().equals(BigInteger.ONE)) {
            int m = perMonth.getDenominator().intValueExact();
            int delta = DateTimeUtils.subtractMonths((int)date2, (int)date);
            return Math.floorDiv(delta, m);
        }
        return date;
    }

    public long diffTimestamp(long timestamp, long timestamp2, TimeFrame frame) {
        TimeFrame msFrame = this.get(TimeUnit.MILLISECOND);
        BigFraction perMilli = frame.per(msFrame);
        if (perMilli != null && perMilli.getNumerator().equals(BigInteger.ONE)) {
            long m = perMilli.getDenominator().longValueExact();
            long delta = timestamp2 - timestamp;
            return Math.floorDiv(delta, m);
        }
        TimeFrame monthFrame = this.get(TimeUnit.MONTH);
        BigFraction perMonth = frame.per(monthFrame);
        if (perMonth != null && perMonth.getNumerator().equals(BigInteger.ONE)) {
            long m = perMonth.getDenominator().longValueExact();
            long delta = DateTimeUtils.subtractMonths((long)timestamp2, (long)timestamp);
            return Math.floorDiv(delta, m);
        }
        return timestamp;
    }

    public static interface Builder {
        public TimeFrameSet build();

        public Builder addCore(String var1);

        public Builder addQuotient(String var1, String var2, String var3);

        public Builder addMultiple(String var1, Number var2, String var3);

        public Builder addDivision(String var1, Number var2, String var3);

        public Builder addRollup(String var1, String var2);

        public Builder addAll(TimeFrameSet var1);

        public Builder withEpoch(TimestampString var1);

        public Builder addAlias(String var1, String var2);
    }
}

