/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.SingleRel;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Intersect;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.Minus;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.Sort;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.core.Union;
import org.apache.hive.druid.org.apache.calcite.rel.core.Values;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableIntersectEmptyPruneRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableJoinLeftEmptyRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableJoinRightEmptyRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableMinusEmptyPruneRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableRemoveEmptySingleRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableSortFetchZeroRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableUnionEmptyPruneRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableZeroMaxRowsRuleConfig;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexDynamicParam;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

public abstract class PruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = UnionEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule MINUS_INSTANCE = MinusEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule INTERSECT_INSTANCE = IntersectEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule EMPTY_TABLE_INSTANCE = ImmutableZeroMaxRowsRuleConfig.DEFAULT.toRule();
    public static final RelOptRule PROJECT_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.PROJECT.toRule();
    public static final RelOptRule FILTER_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.FILTER.toRule();
    public static final RelOptRule SORT_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.SORT.toRule();
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = SortFetchZeroRuleConfig.DEFAULT.toRule();
    public static final RelOptRule AGGREGATE_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.AGGREGATE.toRule();
    public static final RelOptRule JOIN_LEFT_INSTANCE = JoinLeftEmptyRuleConfig.DEFAULT.toRule();
    public static final RelOptRule JOIN_RIGHT_INSTANCE = JoinRightEmptyRuleConfig.DEFAULT.toRule();

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return PruneEmptyRules.isEmpty(((HepRelVertex)node).getCurrentRel());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!PruneEmptyRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    @Value.Immutable
    public static interface ZeroMaxRowsRuleConfig
    extends PruneEmptyRule.Config {
        public static final ZeroMaxRowsRuleConfig DEFAULT = ImmutableZeroMaxRowsRuleConfig.of().withOperandSupplier(b0 -> b0.operand(TableScan.class).noInputs()).withDescription("PruneZeroRowsTable");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public boolean matches(RelOptRuleCall call) {
                    Object node = call.rel(0);
                    Double maxRowCount = call.getMetadataQuery().getMaxRowCount((RelNode)node);
                    return maxRowCount != null && maxRowCount == 0.0;
                }

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Object node = call.rel(0);
                    RelNode emptyValues = call.builder().push((RelNode)node).empty().build();
                    RelTraitSet traits = node.getTraitSet();
                    if (emptyValues.getConvention() != null) {
                        traits = traits.replace(emptyValues.getConvention());
                    }
                    emptyValues = emptyValues.copy(traits, Collections.emptyList());
                    call.transformTo(emptyValues);
                }
            };
        }
    }

    @Value.Immutable
    public static interface JoinRightEmptyRuleConfig
    extends PruneEmptyRule.Config {
        public static final JoinRightEmptyRuleConfig DEFAULT = ImmutableJoinRightEmptyRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Join.class).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("PruneEmptyJoin(right)");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    Object left = call.rel(1);
                    Values empty = (Values)call.rel(2);
                    RelBuilder relBuilder = call.builder();
                    if (join.getJoinType().generatesNullsOnRight()) {
                        List<RexLiteral> nullLiterals = Collections.nCopies(empty.getRowType().getFieldCount(), relBuilder.literal(null));
                        call.transformTo(relBuilder.push((RelNode)left).project(Iterables.concat(relBuilder.fields(), nullLiterals)).convert(join.getRowType(), true).build());
                        return;
                    }
                    if (join.getJoinType() == JoinRelType.ANTI) {
                        call.transformTo(join.getLeft());
                        return;
                    }
                    call.transformTo(relBuilder.push(join).empty().build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface JoinLeftEmptyRuleConfig
    extends PruneEmptyRule.Config {
        public static final JoinLeftEmptyRuleConfig DEFAULT = ImmutableJoinLeftEmptyRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Join.class).inputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).withDescription("PruneEmptyJoin(left)");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    Values empty = (Values)call.rel(1);
                    Object right = call.rel(2);
                    RelBuilder relBuilder = call.builder();
                    if (join.getJoinType().generatesNullsOnLeft()) {
                        List<RexLiteral> nullLiterals = Collections.nCopies(empty.getRowType().getFieldCount(), relBuilder.literal(null));
                        call.transformTo(relBuilder.push((RelNode)right).project(Iterables.concat(nullLiterals, relBuilder.fields())).convert(join.getRowType(), true).build());
                        return;
                    }
                    call.transformTo(relBuilder.push(join).empty().build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface SortFetchZeroRuleConfig
    extends PruneEmptyRule.Config {
        public static final SortFetchZeroRuleConfig DEFAULT = ImmutableSortFetchZeroRuleConfig.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs()).withDescription("PruneSortLimit0");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Sort sort = (Sort)call.rel(0);
                    if (sort.fetch != null && !(sort.fetch instanceof RexDynamicParam) && RexLiteral.intValue(sort.fetch) == 0) {
                        RelNode emptyValues = call.builder().push(sort).empty().build();
                        RelTraitSet traits = sort.getTraitSet();
                        if (emptyValues.getConvention() != null) {
                            traits = traits.replace(emptyValues.getConvention());
                        }
                        emptyValues = emptyValues.copy(traits, Collections.emptyList());
                        call.transformTo(emptyValues);
                    }
                }
            };
        }
    }

    @Value.Immutable
    public static interface IntersectEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        public static final IntersectEmptyPruneRuleConfig DEFAULT = ImmutableIntersectEmptyPruneRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Intersect.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Intersect");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Intersect intersect = (Intersect)call.rel(0);
                    RelBuilder relBuilder = call.builder();
                    relBuilder.push(intersect).empty();
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface MinusEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        public static final MinusEmptyPruneRuleConfig DEFAULT = ImmutableMinusEmptyPruneRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Minus.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Minus");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Minus minus = (Minus)call.rel(0);
                    List<RelNode> inputs = minus.getInputs();
                    assert (inputs != null);
                    int nonEmptyInputs = 0;
                    RelBuilder relBuilder = call.builder();
                    for (RelNode input : inputs) {
                        if (!PruneEmptyRules.isEmpty(input)) {
                            relBuilder.push(input);
                            ++nonEmptyInputs;
                            continue;
                        }
                        if (nonEmptyInputs != 0) continue;
                        break;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(minus);
                    if (nonEmptyInputs == 0) {
                        relBuilder.push(minus).empty();
                    } else {
                        relBuilder.minus(minus.all, nonEmptyInputs);
                        relBuilder.convert(minus.getRowType(), true);
                    }
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface UnionEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        public static final UnionEmptyPruneRuleConfig DEFAULT = ImmutableUnionEmptyPruneRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Union.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Union");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Union union = (Union)call.rel(0);
                    List<RelNode> inputs = union.getInputs();
                    assert (inputs != null);
                    RelBuilder relBuilder = call.builder();
                    int nonEmptyInputs = 0;
                    for (RelNode input : inputs) {
                        if (PruneEmptyRules.isEmpty(input)) continue;
                        relBuilder.push(input);
                        ++nonEmptyInputs;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(union);
                    if (nonEmptyInputs == 0) {
                        relBuilder.push(union).empty();
                    } else {
                        relBuilder.union(union.all, nonEmptyInputs);
                        relBuilder.convert(union.getRowType(), true);
                    }
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    public static class RemoveEmptySingleRule
    extends PruneEmptyRule {
        RemoveEmptySingleRule(RemoveEmptySingleRuleConfig config) {
            super(config);
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, String description) {
            this(ImmutableRemoveEmptySingleRuleConfig.of().withDescription(description).as(ImmutableRemoveEmptySingleRuleConfig.class).withOperandFor(clazz, singleRel -> true));
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, java.util.function.Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(ImmutableRemoveEmptySingleRuleConfig.of().withRelBuilderFactory(relBuilderFactory).withDescription(description).as(ImmutableRemoveEmptySingleRuleConfig.class).withOperandFor(clazz, predicate));
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(ImmutableRemoveEmptySingleRuleConfig.of().withRelBuilderFactory(relBuilderFactory).withDescription(description).as(ImmutableRemoveEmptySingleRuleConfig.class).withOperandFor(clazz, predicate::apply));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            SingleRel singleRel = (SingleRel)call.rel(0);
            RelNode emptyValues = call.builder().push(singleRel).empty().build();
            RelTraitSet traits = singleRel.getTraitSet();
            if (emptyValues.getConvention() != null) {
                traits = traits.replace(emptyValues.getConvention());
            }
            emptyValues = emptyValues.copy(traits, Collections.emptyList());
            call.transformTo(emptyValues);
        }

        @Value.Immutable
        public static interface RemoveEmptySingleRuleConfig
        extends PruneEmptyRule.Config {
            public static final RemoveEmptySingleRuleConfig PROJECT = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptyProject").withOperandFor(Project.class, project -> true);
            public static final RemoveEmptySingleRuleConfig FILTER = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptyFilter").withOperandFor(Filter.class, singleRel -> true);
            public static final RemoveEmptySingleRuleConfig SORT = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptySort").withOperandFor(Sort.class, singleRel -> true);
            public static final RemoveEmptySingleRuleConfig AGGREGATE = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptyAggregate").withOperandFor(Aggregate.class, Aggregate::isNotGrandTotal);

            @Override
            default public RemoveEmptySingleRule toRule() {
                return new RemoveEmptySingleRule(this);
            }

            default public <R extends RelNode> RemoveEmptySingleRuleConfig withOperandFor(Class<R> relClass, java.util.function.Predicate<R> predicate) {
                return this.withOperandSupplier(b0 -> b0.operand(relClass).predicate(predicate).oneInput(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).as(RemoveEmptySingleRuleConfig.class);
            }
        }
    }

    protected static abstract class PruneEmptyRule
    extends RelRule<Config>
    implements SubstitutionRule {
        protected PruneEmptyRule(Config config) {
            super(config);
        }

        @Override
        public boolean autoPruneOld() {
            return true;
        }

        public static interface Config
        extends RelRule.Config {
            @Override
            public PruneEmptyRule toRule();
        }
    }
}

