/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableProjectJoinRemoveRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectJoinRemoveRule
extends RelRule<Config>
implements SubstitutionRule {
    protected ProjectJoinRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectJoinRemoveRule(Class<? extends Project> projectClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(projectClass, joinClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project node;
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        boolean isLeftJoin = join.getJoinType() == JoinRelType.LEFT;
        int lower = isLeftJoin ? join.getLeft().getRowType().getFieldCount() : 0;
        int upper = isLeftJoin ? join.getRowType().getFieldCount() : join.getLeft().getRowType().getFieldCount();
        for (RexNode expr2 : project.getProjects()) {
            if (!RelOptUtil.InputFinder.bits(expr2).asList().stream().anyMatch(i -> i >= lower && i < upper)) continue;
            return;
        }
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(join.getLeft(), join.getRight(), join.getCondition(), leftKeys, rightKeys, new ArrayList<Boolean>());
        ArrayList<Integer> joinKeys = isLeftJoin ? rightKeys : leftKeys;
        ImmutableBitSet.Builder columns = ImmutableBitSet.builder();
        joinKeys.forEach(columns::set);
        RelMetadataQuery mq = call.getMetadataQuery();
        if (!Boolean.TRUE.equals(mq.areColumnsUnique(isLeftJoin ? join.getRight() : join.getLeft(), columns.build()))) {
            return;
        }
        if (isLeftJoin) {
            node = project.copy(project.getTraitSet(), join.getLeft(), project.getProjects(), project.getRowType());
        } else {
            int offset = join.getLeft().getRowType().getFieldCount();
            List<RexNode> newExprs = project.getProjects().stream().map(expr -> RexUtil.shift(expr, -offset)).collect(Collectors.toList());
            node = project.copy(project.getTraitSet(), join.getRight(), newExprs, project.getRowType());
        }
        call.transformTo(node);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectJoinRemoveRule.Config.of().withOperandFor(LogicalProject.class, LogicalJoin.class);

        @Override
        default public ProjectJoinRemoveRule toRule() {
            return new ProjectJoinRemoveRule(this);
        }

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(joinClass).predicate(join -> join.getJoinType() == JoinRelType.LEFT || join.getJoinType() == JoinRelType.RIGHT).anyInputs())).as(Config.class);
        }
    }
}

