/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.SetOp;
import org.apache.hive.druid.org.apache.calcite.rel.core.Union;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableJoinUnionTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.TransformationRule;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinUnionTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinUnionTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinUnionTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        this(Config.LEFT.withRelBuilderFactory(relBuilderFactory).withDescription(description).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        boolean unionOnLeft;
        Object otherInput;
        Union unionRel;
        Join join = (Join)call.rel(0);
        if (call.rel(1) instanceof Union) {
            unionRel = (Union)call.rel(1);
            otherInput = call.rel(2);
            unionOnLeft = true;
        } else {
            otherInput = call.rel(1);
            unionRel = (Union)call.rel(2);
            unionOnLeft = false;
        }
        if (!unionRel.all) {
            return;
        }
        if (!join.getVariablesSet().isEmpty()) {
            return;
        }
        if (unionOnLeft ? join.getJoinType().generatesNullsOnLeft() : join.getJoinType().generatesNullsOnRight() || !join.getJoinType().projectsRight()) {
            return;
        }
        ArrayList<RelNode> newUnionInputs = new ArrayList<RelNode>();
        for (RelNode input : unionRel.getInputs()) {
            Object joinRight;
            RelNode joinLeft;
            if (unionOnLeft) {
                joinLeft = input;
                joinRight = otherInput;
            } else {
                joinLeft = otherInput;
                joinRight = input;
            }
            newUnionInputs.add(join.copy(join.getTraitSet(), join.getCondition(), joinLeft, (RelNode)joinRight, join.getJoinType(), join.isSemiJoinDone()));
        }
        SetOp newUnionRel = unionRel.copy(unionRel.getTraitSet(), newUnionInputs, true);
        call.transformTo(newUnionRel);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config LEFT = ImmutableJoinUnionTransposeRule.Config.of().withDescription("JoinUnionTransposeRule(Union-Other)").withOperandFor(Join.class, Union.class, true);
        public static final Config RIGHT = ImmutableJoinUnionTransposeRule.Config.of().withDescription("JoinUnionTransposeRule(Other-Union)").withOperandFor(Join.class, Union.class, false);

        @Override
        default public JoinUnionTransposeRule toRule() {
            return new JoinUnionTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass, Class<? extends Union> unionClass, boolean left) {
            Class<RelNode> leftClass = left ? unionClass : RelNode.class;
            Class rightClass = left ? RelNode.class : unionClass;
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(leftClass).anyInputs(), b2 -> b2.operand(rightClass).anyInputs())).as(Config.class);
        }
    }
}

