/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hive.druid.com.google.common.base.MoreObjects;
import org.apache.hive.druid.com.google.common.primitives.Booleans;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FilterProjectTransposeRule", generator="Immutables")
final class ImmutableFilterProjectTransposeRule {
    private ImmutableFilterProjectTransposeRule() {
    }

    @CheckReturnValue
    @Generated(from="FilterProjectTransposeRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements FilterProjectTransposeRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final boolean copyFilter;
        private final boolean copyProject;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.copyFilter = this.initShim.isCopyFilter();
            this.copyProject = this.initShim.isCopyProject();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            if (builder.copyFilterIsSet()) {
                this.initShim.withCopyFilter(builder.copyFilter);
            }
            if (builder.copyProjectIsSet()) {
                this.initShim.withCopyProject(builder.copyProject);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.copyFilter = this.initShim.isCopyFilter();
            this.copyProject = this.initShim.isCopyProject();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier, boolean copyFilter, boolean copyProject) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.copyFilter = copyFilter;
            this.copyProject = copyProject;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return FilterProjectTransposeRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return FilterProjectTransposeRule.Config.super.operandSupplier();
        }

        private boolean isCopyFilterInitialize() {
            return FilterProjectTransposeRule.Config.super.isCopyFilter();
        }

        private boolean isCopyProjectInitialize() {
            return FilterProjectTransposeRule.Config.super.isCopyProject();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public boolean isCopyFilter() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isCopyFilter() : this.copyFilter;
        }

        @Override
        public boolean isCopyProject() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isCopyProject() : this.copyProject;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.operandSupplier, this.copyFilter, this.copyProject));
        }

        @Override
        public final Config withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.operandSupplier, this.copyFilter, this.copyProject));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue, this.copyFilter, this.copyProject));
        }

        @Override
        public final Config withCopyFilter(boolean value) {
            if (this.copyFilter == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, value, this.copyProject));
        }

        @Override
        public final Config withCopyProject(boolean value) {
            if (this.copyProject == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, this.copyFilter, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.copyFilter == another.copyFilter && this.copyProject == another.copyProject;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.relBuilderFactory.hashCode();
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.operandSupplier.hashCode();
            h += (h << 5) + Booleans.hashCode(this.copyFilter);
            h += (h << 5) + Booleans.hashCode(this.copyProject);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("relBuilderFactory", (Object)this.relBuilderFactory).add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).add("copyFilter", this.copyFilter).add("copyProject", this.copyProject).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(FilterProjectTransposeRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="FilterProjectTransposeRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_COPY_FILTER = 1L;
            private static final long OPT_BIT_COPY_PROJECT = 2L;
            private long optBits;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            private boolean copyFilter;
            private boolean copyProject;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(FilterProjectTransposeRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
                if (object instanceof FilterProjectTransposeRule.Config) {
                    instance = (FilterProjectTransposeRule.Config)object;
                    this.withCopyProject(instance.isCopyProject());
                    this.withCopyFilter(instance.isCopyFilter());
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCopyFilter(boolean copyFilter) {
                this.copyFilter = copyFilter;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCopyProject(boolean copyProject) {
                this.copyProject = copyProject;
                this.optBits |= 2L;
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean copyFilterIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean copyProjectIsSet() {
                return (this.optBits & 2L) != 0L;
            }
        }

        @Generated(from="FilterProjectTransposeRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte copyFilterBuildStage = 0;
            private boolean copyFilter;
            private byte copyProjectBuildStage = 0;
            private boolean copyProject;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            boolean isCopyFilter() {
                if (this.copyFilterBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.copyFilterBuildStage == 0) {
                    this.copyFilterBuildStage = (byte)-1;
                    this.copyFilter = Config.this.isCopyFilterInitialize();
                    this.copyFilterBuildStage = 1;
                }
                return this.copyFilter;
            }

            void withCopyFilter(boolean copyFilter) {
                this.copyFilter = copyFilter;
                this.copyFilterBuildStage = 1;
            }

            boolean isCopyProject() {
                if (this.copyProjectBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.copyProjectBuildStage == 0) {
                    this.copyProjectBuildStage = (byte)-1;
                    this.copyProject = Config.this.isCopyProjectInitialize();
                    this.copyProjectBuildStage = 1;
                }
                return this.copyProject;
            }

            void withCopyProject(boolean copyProject) {
                this.copyProject = copyProject;
                this.copyProjectBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.copyFilterBuildStage == -1) {
                    attributes.add("copyFilter");
                }
                if (this.copyProjectBuildStage == -1) {
                    attributes.add("copyProject");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

