/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.prepare;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.TableExpressionFactory;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptSchema;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.hive.druid.org.apache.calcite.prepare.Prepare;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistribution;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelRecordType;
import org.apache.hive.druid.org.apache.calcite.schema.ColumnStrategy;
import org.apache.hive.druid.org.apache.calcite.schema.Function;
import org.apache.hive.druid.org.apache.calcite.schema.ModifiableTable;
import org.apache.hive.druid.org.apache.calcite.schema.Path;
import org.apache.hive.druid.org.apache.calcite.schema.ScannableTable;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaVersion;
import org.apache.hive.druid.org.apache.calcite.schema.Schemas;
import org.apache.hive.druid.org.apache.calcite.schema.StreamableTable;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.TemporalTable;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.schema.Wrapper;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAccessType;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlModality;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.hive.druid.org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.hive.druid.org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelOptTableImpl
extends Prepare.AbstractPreparingTable {
    private final @Nullable RelOptSchema schema;
    private final RelDataType rowType;
    private final @Nullable Table table;
    private final @Nullable TableExpressionFactory tableExpressionFactory;
    private final ImmutableList<String> names;
    private final @Nullable Double rowCount;

    private RelOptTableImpl(@Nullable RelOptSchema schema, RelDataType rowType, List<String> names, @Nullable Table table, @Nullable TableExpressionFactory tableExpressionFactory, @Nullable Double rowCount) {
        this.schema = schema;
        this.rowType = Objects.requireNonNull(rowType, "rowType");
        this.names = ImmutableList.copyOf(names);
        this.table = table;
        this.tableExpressionFactory = tableExpressionFactory;
        this.rowCount = rowCount;
    }

    public static RelOptTableImpl create(@Nullable RelOptSchema schema, RelDataType rowType, List<String> names, Expression expression) {
        return new RelOptTableImpl(schema, rowType, names, null, c -> expression, null);
    }

    @Deprecated
    public static RelOptTableImpl create(@Nullable RelOptSchema schema, RelDataType rowType, List<String> names, Table table, Expression expression) {
        return RelOptTableImpl.create(schema, rowType, names, table, (Class c) -> expression);
    }

    public static RelOptTableImpl create(@Nullable RelOptSchema schema, RelDataType rowType, List<String> names, Table table, TableExpressionFactory expressionFactory) {
        return new RelOptTableImpl(schema, rowType, names, table, expressionFactory, table.getStatistic().getRowCount());
    }

    public static RelOptTableImpl create(@Nullable RelOptSchema schema, RelDataType rowType, Table table, Path path) {
        MySchemaPlus schemaPlus = MySchemaPlus.create(path);
        return new RelOptTableImpl(schema, rowType, Pair.left(path), table, c -> Schemas.getTableExpression(schemaPlus, (String)Util.last(path).left, table, c), table.getStatistic().getRowCount());
    }

    public static RelOptTableImpl create(@Nullable RelOptSchema schema, RelDataType rowType, CalciteSchema.TableEntry tableEntry, @Nullable Double rowCount) {
        Table table = tableEntry.getTable();
        return new RelOptTableImpl(schema, rowType, tableEntry.path(), table, c -> Schemas.getTableExpression(tableEntry.schema.plus(), tableEntry.name, table, c), rowCount);
    }

    public RelOptTableImpl copy(RelDataType newRowType) {
        return new RelOptTableImpl(this.schema, newRowType, this.names, this.table, this.tableExpressionFactory, this.rowCount);
    }

    public String toString() {
        return "RelOptTableImpl{schema=" + this.schema + ", names= " + this.names + ", table=" + this.table + ", rowType=" + this.rowType + '}';
    }

    public static RelOptTableImpl create(@Nullable RelOptSchema schema, RelDataType rowType, Table table, ImmutableList<String> names) {
        assert (table instanceof TranslatableTable || table instanceof ScannableTable || table instanceof ModifiableTable);
        return new RelOptTableImpl(schema, rowType, names, table, null, null);
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        T t;
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isInstance(this.table)) {
            return clazz.cast(this.table);
        }
        if (this.table instanceof Wrapper && (t = ((Wrapper)((Object)this.table)).unwrap(clazz)) != null) {
            return t;
        }
        if (clazz == CalciteSchema.class && this.schema != null) {
            return clazz.cast(Schemas.subSchema(((CalciteCatalogReader)this.schema).rootSchema, Util.skipLast(this.getQualifiedName())));
        }
        return null;
    }

    @Override
    public @Nullable Expression getExpression(Class clazz) {
        if (this.tableExpressionFactory == null) {
            return null;
        }
        return this.tableExpressionFactory.create(clazz);
    }

    @Override
    protected RelOptTable extend(Table extendedTable) {
        RelOptSchema schema = Objects.requireNonNull(this.getRelOptSchema(), "relOptSchema");
        RelDataType extendedRowType = extendedTable.getRowType(schema.getTypeFactory());
        return new RelOptTableImpl(schema, extendedRowType, this.getQualifiedName(), extendedTable, this.tableExpressionFactory, this.getRowCount());
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof RelOptTableImpl && this.rowType.equals(((RelOptTableImpl)obj).getRowType()) && this.table == ((RelOptTableImpl)obj).table;
    }

    public int hashCode() {
        return this.table == null ? super.hashCode() : this.table.hashCode();
    }

    @Override
    public double getRowCount() {
        Double rowCount;
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (this.table != null && (rowCount = this.table.getStatistic().getRowCount()) != null) {
            return rowCount;
        }
        return 100.0;
    }

    @Override
    public @Nullable RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        if (this.getRowType().isDynamicStruct()) {
            RelRecordType staticRowType = new RelRecordType(this.getRowType().getFieldList());
            RelOptTableImpl relOptTable = this.copy(staticRowType);
            return relOptTable.toRel(context);
        }
        List<ColumnStrategy> strategies = this.getColumnStrategies();
        if (strategies.contains((Object)ColumnStrategy.VIRTUAL)) {
            RelDataTypeFactory.FieldInfoBuilder b = context.getCluster().getTypeFactory().builder();
            for (RelDataTypeField field : this.rowType.getFieldList()) {
                if (strategies.get(field.getIndex()) == ColumnStrategy.VIRTUAL) continue;
                ((RelDataTypeFactory.Builder)b).add(field.getName(), field.getType());
            }
            RelOptTableImpl relOptTable = new RelOptTableImpl(this.schema, b.build(), this.names, this.table, this.tableExpressionFactory, this.rowCount){

                @Override
                public <T> @Nullable T unwrap(Class<T> clazz) {
                    if (clazz.isAssignableFrom(InitializerExpressionFactory.class)) {
                        return clazz.cast(NullInitializerExpressionFactory.INSTANCE);
                    }
                    return super.unwrap(clazz);
                }
            };
            return relOptTable.toRel(context);
        }
        if (this.table instanceof TranslatableTable) {
            return ((TranslatableTable)this.table).toRel(context, this);
        }
        return LogicalTableScan.create(context.getCluster(), this, context.getTableHints());
    }

    @Override
    public @Nullable List<RelCollation> getCollationList() {
        if (this.table != null) {
            return this.table.getStatistic().getCollations();
        }
        return ImmutableList.of();
    }

    @Override
    public @Nullable RelDistribution getDistribution() {
        if (this.table != null) {
            return this.table.getStatistic().getDistribution();
        }
        return RelDistributionTraitDef.INSTANCE.getDefault();
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        if (this.table != null) {
            return this.table.getStatistic().isKey(columns);
        }
        return false;
    }

    @Override
    public @Nullable List<ImmutableBitSet> getKeys() {
        if (this.table != null) {
            return this.table.getStatistic().getKeys();
        }
        return ImmutableList.of();
    }

    @Override
    public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
        if (this.table != null) {
            return this.table.getStatistic().getReferentialConstraints();
        }
        return ImmutableList.of();
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        switch (modality) {
            case STREAM: {
                return this.table instanceof StreamableTable;
            }
        }
        return !(this.table instanceof StreamableTable);
    }

    @Override
    public boolean isTemporal() {
        return this.table instanceof TemporalTable;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.names;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        if (this.table == null) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        List<RelCollation> collations = this.table.getStatistic().getCollations();
        if (collations == null) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        for (RelCollation collation : collations) {
            RelFieldCollation fieldCollation = collation.getFieldCollations().get(0);
            int fieldIndex = fieldCollation.getFieldIndex();
            if (fieldIndex >= this.rowType.getFieldCount() || !this.rowType.getFieldNames().get(fieldIndex).equals(columnName)) continue;
            return fieldCollation.direction.monotonicity();
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }

    public static List<ColumnStrategy> columnStrategies(final RelOptTable table) {
        final int fieldCount = table.getRowType().getFieldCount();
        final InitializerExpressionFactory ief = Util.first(table.unwrap(InitializerExpressionFactory.class), NullInitializerExpressionFactory.INSTANCE);
        return new AbstractList<ColumnStrategy>(){

            @Override
            public int size() {
                return fieldCount;
            }

            @Override
            public ColumnStrategy get(int index) {
                return ief.generationStrategy(table, index);
            }
        };
    }

    public static int realOrdinal(RelOptTable table, int i) {
        List<ColumnStrategy> strategies = table.getColumnStrategies();
        int n = 0;
        block3: for (int j = 0; j < i; ++j) {
            switch (strategies.get(j)) {
                case VIRTUAL: {
                    ++n;
                    continue block3;
                }
            }
        }
        return i - n;
    }

    public static RelDataType realRowType(RelOptTable table) {
        RelDataType rowType = table.getRowType();
        List<ColumnStrategy> strategies = RelOptTableImpl.columnStrategies(table);
        if (!strategies.contains((Object)ColumnStrategy.VIRTUAL)) {
            return rowType;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = Objects.requireNonNull(table.getRelOptSchema(), () -> "relOptSchema for table " + table).getTypeFactory().builder();
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (strategies.get(field.getIndex()) == ColumnStrategy.VIRTUAL) continue;
            ((RelDataTypeFactory.Builder)builder).add(field);
        }
        return builder.build();
    }

    private static class MySchemaPlus
    implements SchemaPlus {
        private final @Nullable SchemaPlus parent;
        private final String name;
        private final Schema schema;

        MySchemaPlus(@Nullable SchemaPlus parent, String name, Schema schema) {
            this.parent = parent;
            this.name = name;
            this.schema = schema;
        }

        public static MySchemaPlus create(Path path) {
            Pair<String, Schema> pair = Util.last(path);
            MySchemaPlus parent = path.size() == 1 ? null : MySchemaPlus.create(path.parent());
            return new MySchemaPlus(parent, (String)pair.left, (Schema)pair.right);
        }

        @Override
        public @Nullable SchemaPlus getParentSchema() {
            return this.parent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public @Nullable SchemaPlus getSubSchema(String name) {
            Schema subSchema = this.schema.getSubSchema(name);
            return subSchema == null ? null : new MySchemaPlus(this, name, subSchema);
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Table table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeTable(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Function function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, RelProtoDataType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Lattice lattice) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMutable() {
            return this.schema.isMutable();
        }

        @Override
        public <T> @Nullable T unwrap(Class<T> clazz) {
            return null;
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCacheEnabled() {
            return false;
        }

        @Override
        public @Nullable Table getTable(String name) {
            return this.schema.getTable(name);
        }

        @Override
        public Set<String> getTableNames() {
            return this.schema.getTableNames();
        }

        @Override
        public @Nullable RelProtoDataType getType(String name) {
            return this.schema.getType(name);
        }

        @Override
        public Set<String> getTypeNames() {
            return this.schema.getTypeNames();
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return this.schema.getFunctions(name);
        }

        @Override
        public Set<String> getFunctionNames() {
            return this.schema.getFunctionNames();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return this.schema.getSubSchemaNames();
        }

        @Override
        public Expression getExpression(@Nullable SchemaPlus parentSchema, String name) {
            return this.schema.getExpression(parentSchema, name);
        }

        @Override
        public Schema snapshot(SchemaVersion version) {
            throw new UnsupportedOperationException();
        }
    }
}

