/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan.hep;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.linq4j.Nullness;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Function2;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Functions;
import org.apache.hive.druid.org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.CommonRelSubExprRule;
import org.apache.hive.druid.org.apache.calcite.plan.Context;
import org.apache.hive.druid.org.apache.calcite.plan.RelDigest;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCostImpl;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptMaterialization;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepInstruction;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepProgram;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepRelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepState;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.convert.Converter;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.hive.druid.org.apache.calcite.rel.convert.TraitMatchingRule;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.graph.BreadthFirstIterator;
import org.apache.hive.druid.org.apache.calcite.util.graph.CycleDetector;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.hive.druid.org.apache.calcite.util.graph.DepthFirstIterator;
import org.apache.hive.druid.org.apache.calcite.util.graph.DirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.graph.Graphs;
import org.apache.hive.druid.org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HepPlanner
extends AbstractRelOptPlanner {
    private final HepProgram mainProgram;
    private @Nullable HepRelVertex root;
    private @Nullable RelTraitSet requestedRootTraits;
    private final Map<RelDigest, HepRelVertex> mapDigestToVertex = new HashMap<RelDigest, HepRelVertex>();
    private int nTransformations;
    private int graphSizeLastGC;
    private int nTransformationsLastGC;
    private final boolean noDag;
    private final DirectedGraph<HepRelVertex, DefaultEdge> graph = DefaultDirectedGraph.create();
    private final Function2<RelNode, RelNode, Void> onCopyHook;
    private final List<RelOptMaterialization> materializations = new ArrayList<RelOptMaterialization>();

    public HepPlanner(HepProgram program) {
        this(program, null, false, null, RelOptCostImpl.FACTORY);
    }

    public HepPlanner(HepProgram program, @Nullable Context context) {
        this(program, context, false, null, RelOptCostImpl.FACTORY);
    }

    public HepPlanner(HepProgram program, @Nullable Context context, boolean noDag, @Nullable Function2<RelNode, RelNode, Void> onCopyHook, RelOptCostFactory costFactory) {
        super(costFactory, context);
        this.mainProgram = Objects.requireNonNull(program, "program");
        this.onCopyHook = Util.first(onCopyHook, Functions.ignore2());
        this.noDag = noDag;
    }

    @Override
    public void setRoot(RelNode rel) {
        this.root = this.addRelToGraph(rel);
        this.dumpGraph();
    }

    @Override
    public @Nullable RelNode getRoot() {
        return this.root;
    }

    @Override
    public void clear() {
        super.clear();
        for (RelOptRule rule : this.getRules()) {
            this.removeRule(rule);
        }
        this.materializations.clear();
    }

    @Override
    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        if (rel == this.root || rel == Objects.requireNonNull(this.root, "root").getCurrentRel()) {
            this.requestedRootTraits = toTraits;
        }
        return rel;
    }

    @Override
    public RelNode findBestExp() {
        Objects.requireNonNull(this.root, "root");
        this.executeProgram(this.mainProgram);
        this.collectGarbage();
        this.dumpRuleAttemptsInfo();
        return this.buildFinalPlan(Objects.requireNonNull(this.root, "root"));
    }

    private void executeProgram(HepProgram program) {
        HepInstruction.PrepareContext px = HepInstruction.PrepareContext.create(this);
        HepProgram.State state = program.prepare(px);
        ((HepState)state).execute();
    }

    void executeProgram(HepProgram instruction, HepProgram.State state) {
        state.init();
        state.instructionStates.forEach(instructionState -> {
            instructionState.execute();
            int delta = this.nTransformations - this.nTransformationsLastGC;
            if (delta > this.graphSizeLastGC) {
                this.collectGarbage();
            }
        });
    }

    void executeMatchLimit(HepInstruction.MatchLimit instruction, HepInstruction.MatchLimit.State state) {
        LOGGER.trace("Setting match limit to {}", (Object)instruction.limit);
        state.programState.matchLimit = instruction.limit;
    }

    void executeMatchOrder(HepInstruction.MatchOrder instruction, HepInstruction.MatchOrder.State state) {
        LOGGER.trace("Setting match order to {}", (Object)instruction.order);
        state.programState.matchOrder = instruction.order;
    }

    void executeRuleInstance(HepInstruction.RuleInstance instruction, HepInstruction.RuleInstance.State state) {
        if (state.programState.skippingGroup()) {
            return;
        }
        this.applyRules(state.programState, ImmutableList.of(instruction.rule), true);
    }

    void executeRuleLookup(HepInstruction.RuleLookup instruction, HepInstruction.RuleLookup.State state) {
        if (state.programState.skippingGroup()) {
            return;
        }
        RelOptRule rule = state.rule;
        if (rule == null) {
            state.rule = rule = this.getRuleByDescription(instruction.ruleDescription);
            LOGGER.trace("Looking up rule with description {}, found {}", (Object)instruction.ruleDescription, (Object)rule);
        }
        if (rule != null) {
            this.applyRules(state.programState, ImmutableList.of(rule), true);
        }
    }

    void executeRuleClass(HepInstruction.RuleClass instruction, HepInstruction.RuleClass.State state) {
        if (state.programState.skippingGroup()) {
            return;
        }
        LOGGER.trace("Applying rule class {}", instruction.ruleClass);
        Set<RelOptRule> ruleSet = state.ruleSet;
        if (ruleSet == null) {
            state.ruleSet = ruleSet = new LinkedHashSet<RelOptRule>();
            Class<? extends RelOptRule> ruleClass = instruction.ruleClass;
            for (RelOptRule rule : this.mapDescToRule.values()) {
                if (!ruleClass.isInstance(rule)) continue;
                ruleSet.add(rule);
            }
        }
        this.applyRules(state.programState, ruleSet, true);
    }

    void executeRuleCollection(HepInstruction.RuleCollection instruction, HepInstruction.RuleCollection.State state) {
        if (state.programState.skippingGroup()) {
            return;
        }
        this.applyRules(state.programState, instruction.rules, true);
    }

    void executeConverterRules(HepInstruction.ConverterRules instruction, HepInstruction.ConverterRules.State state) {
        Preconditions.checkArgument(state.programState.group == null);
        Set<RelOptRule> ruleSet = state.ruleSet;
        if (ruleSet == null) {
            state.ruleSet = ruleSet = new LinkedHashSet<RelOptRule>();
            for (RelOptRule rule : this.mapDescToRule.values()) {
                ConverterRule converter;
                if (!(rule instanceof ConverterRule) || (converter = (ConverterRule)rule).isGuaranteed() != instruction.guaranteed) continue;
                ruleSet.add(converter);
                if (instruction.guaranteed) continue;
                ruleSet.add(TraitMatchingRule.config(converter, RelFactories.LOGICAL_BUILDER).toRule());
            }
        }
        this.applyRules(state.programState, ruleSet, instruction.guaranteed);
    }

    void executeCommonRelSubExprRules(HepInstruction.CommonRelSubExprRules instruction, HepInstruction.CommonRelSubExprRules.State state) {
        Preconditions.checkArgument(state.programState.group == null);
        Set<RelOptRule> ruleSet = state.ruleSet;
        if (ruleSet == null) {
            state.ruleSet = ruleSet = new LinkedHashSet<RelOptRule>();
            for (RelOptRule rule : this.mapDescToRule.values()) {
                if (!(rule instanceof CommonRelSubExprRule)) continue;
                ruleSet.add(rule);
            }
        }
        this.applyRules(state.programState, ruleSet, true);
    }

    void executeSubProgram(HepInstruction.SubProgram instruction, HepInstruction.SubProgram.State state) {
        int nTransformationsBefore;
        LOGGER.trace("Entering subprogram");
        do {
            nTransformationsBefore = this.nTransformations;
            state.programState.execute();
        } while (this.nTransformations != nTransformationsBefore);
        LOGGER.trace("Leaving subprogram");
    }

    void executeBeginGroup(HepInstruction.BeginGroup instruction, HepInstruction.BeginGroup.State state) {
        Preconditions.checkArgument(state.programState.group == null);
        state.programState.group = state.endGroup;
        LOGGER.trace("Entering group");
    }

    void executeEndGroup(HepInstruction.EndGroup instruction, HepInstruction.EndGroup.State state) {
        Preconditions.checkArgument(state.programState.group == state);
        state.programState.group = null;
        state.collecting = false;
        this.applyRules(state.programState, state.ruleSet, true);
        LOGGER.trace("Leaving group");
    }

    private int depthFirstApply(HepProgram.State programState, Iterator<HepRelVertex> iter, Collection<RelOptRule> rules, boolean forceConversions, int nMatches) {
        block0: while (iter.hasNext()) {
            HepRelVertex vertex = iter.next();
            for (RelOptRule rule : rules) {
                HepRelVertex newVertex = this.applyRule(rule, vertex, forceConversions);
                if (newVertex == null || newVertex == vertex) continue;
                if (++nMatches >= programState.matchLimit) {
                    return nMatches;
                }
                Iterator<HepRelVertex> depthIter = this.getGraphIterator(programState, newVertex);
                nMatches = this.depthFirstApply(programState, depthIter, rules, forceConversions, nMatches);
                continue block0;
            }
        }
        return nMatches;
    }

    private void applyRules(HepProgram.State programState, Collection<RelOptRule> rules, boolean forceConversions) {
        boolean fixedPoint;
        HepInstruction.EndGroup.State group = programState.group;
        if (group != null) {
            Preconditions.checkArgument(group.collecting);
            Set<RelOptRule> ruleSet = Objects.requireNonNull(group.ruleSet, "group.ruleSet");
            ruleSet.addAll(rules);
            return;
        }
        LOGGER.trace("Applying rule set {}", rules);
        boolean fullRestartAfterTransformation = programState.matchOrder != HepMatchOrder.ARBITRARY && programState.matchOrder != HepMatchOrder.DEPTH_FIRST;
        int nMatches = 0;
        do {
            Iterator<HepRelVertex> iter = this.getGraphIterator(programState, Objects.requireNonNull(this.root, "root"));
            fixedPoint = true;
            block1: while (iter.hasNext()) {
                HepRelVertex vertex = iter.next();
                for (RelOptRule rule : rules) {
                    HepRelVertex newVertex = this.applyRule(rule, vertex, forceConversions);
                    if (newVertex == null || newVertex == vertex) continue;
                    if (++nMatches >= programState.matchLimit) {
                        return;
                    }
                    if (fullRestartAfterTransformation) {
                        iter = this.getGraphIterator(programState, Objects.requireNonNull(this.root, "root"));
                        continue block1;
                    }
                    iter = this.getGraphIterator(programState, newVertex);
                    if (programState.matchOrder == HepMatchOrder.DEPTH_FIRST && (nMatches = this.depthFirstApply(programState, iter, rules, forceConversions, nMatches)) >= programState.matchLimit) {
                        return;
                    }
                    fixedPoint = false;
                    continue block1;
                }
            }
        } while (!fixedPoint);
    }

    private Iterator<HepRelVertex> getGraphIterator(HepProgram.State programState, HepRelVertex start) {
        this.collectGarbage();
        switch (Objects.requireNonNull(programState.matchOrder, "programState.matchOrder")) {
            case ARBITRARY: 
            case DEPTH_FIRST: {
                return DepthFirstIterator.of(this.graph, start).iterator();
            }
            case TOP_DOWN: {
                assert (start == this.root);
                return TopologicalOrderIterator.of(this.graph).iterator();
            }
        }
        assert (start == this.root);
        ArrayList<HepRelVertex> list = new ArrayList<HepRelVertex>();
        for (HepRelVertex vertex : TopologicalOrderIterator.of(this.graph)) {
            list.add(vertex);
        }
        Collections.reverse(list);
        return list.iterator();
    }

    private @Nullable HepRelVertex applyRule(RelOptRule rule, HepRelVertex vertex, boolean forceConversions) {
        if (!this.graph.vertexSet().contains(vertex)) {
            return null;
        }
        RelTrait parentTrait = null;
        ArrayList<RelNode> parents = null;
        if (rule instanceof ConverterRule) {
            ConverterRule converterRule = (ConverterRule)rule;
            if (converterRule.isGuaranteed() || !forceConversions) {
                if (!this.doesConverterApply(converterRule, vertex)) {
                    return null;
                }
                parentTrait = converterRule.getOutTrait();
            }
        } else if (rule instanceof CommonRelSubExprRule) {
            List<HepRelVertex> parentVertices = this.getVertexParents(vertex);
            if (parentVertices.size() < 2) {
                return null;
            }
            parents = new ArrayList<RelNode>();
            for (HepRelVertex pVertex : parentVertices) {
                parents.add(pVertex.getCurrentRel());
            }
        }
        ArrayList<RelNode> bindings = new ArrayList<RelNode>();
        HashMap<RelNode, List<RelNode>> nodeChildren = new HashMap<RelNode, List<RelNode>>();
        boolean match = HepPlanner.matchOperands(rule.getOperand(), vertex.getCurrentRel(), bindings, nodeChildren);
        if (!match) {
            return null;
        }
        HepRuleCall call = new HepRuleCall(this, rule.getOperand(), bindings.toArray(new RelNode[0]), nodeChildren, parents);
        if (!rule.matches(call)) {
            return null;
        }
        this.fireRule(call);
        if (!call.getResults().isEmpty()) {
            return this.applyTransformationResults(vertex, call, parentTrait);
        }
        return null;
    }

    private boolean doesConverterApply(ConverterRule converterRule, HepRelVertex vertex) {
        RelTrait outTrait = converterRule.getOutTrait();
        List<HepRelVertex> parents = Graphs.predecessorListOf(this.graph, vertex);
        for (HepRelVertex parent : parents) {
            RelNode parentRel = parent.getCurrentRel();
            if (parentRel instanceof Converter || !parentRel.getTraitSet().contains(outTrait)) continue;
            return true;
        }
        return vertex == this.root && this.requestedRootTraits != null && this.requestedRootTraits.contains(outTrait);
    }

    private List<HepRelVertex> getVertexParents(HepRelVertex vertex) {
        ArrayList<HepRelVertex> parents = new ArrayList<HepRelVertex>();
        List<HepRelVertex> parentVertices = Graphs.predecessorListOf(this.graph, vertex);
        for (HepRelVertex pVertex : parentVertices) {
            RelNode parent = pVertex.getCurrentRel();
            for (int i = 0; i < parent.getInputs().size(); ++i) {
                HepRelVertex child = (HepRelVertex)parent.getInputs().get(i);
                if (child != vertex) continue;
                parents.add(pVertex);
            }
        }
        return parents;
    }

    private static boolean matchOperands(RelOptRuleOperand operand, RelNode rel, List<RelNode> bindings, Map<RelNode, List<RelNode>> nodeChildren) {
        if (!operand.matches(rel)) {
            return false;
        }
        for (RelNode relNode : rel.getInputs()) {
            if (relNode instanceof HepRelVertex) continue;
            return false;
        }
        bindings.add(rel);
        List<RelNode> childRels = rel.getInputs();
        switch (operand.childPolicy) {
            case ANY: {
                return true;
            }
            case UNORDERED: {
                for (RelOptRuleOperand relOptRuleOperand : operand.getChildOperands()) {
                    HepRelVertex childRel;
                    boolean bl = false;
                    Iterator<RelNode> iterator = childRels.iterator();
                    while (iterator.hasNext() && !(bl = HepPlanner.matchOperands(relOptRuleOperand, (childRel = (HepRelVertex)iterator.next()).getCurrentRel(), bindings, nodeChildren))) {
                    }
                    if (bl) continue;
                    return false;
                }
                ArrayList<RelNode> arrayList = new ArrayList<RelNode>(childRels.size());
                for (HepRelVertex hepRelVertex : childRels) {
                    arrayList.add(hepRelVertex.getCurrentRel());
                }
                nodeChildren.put(rel, arrayList);
                return true;
            }
        }
        int n = operand.getChildOperands().size();
        if (childRels.size() < n) {
            return false;
        }
        for (Pair<RelNode, RelOptRuleOperand> pair : Pair.zip(childRels, operand.getChildOperands())) {
            boolean match = HepPlanner.matchOperands((RelOptRuleOperand)pair.right, ((HepRelVertex)pair.left).getCurrentRel(), bindings, nodeChildren);
            if (match) continue;
            return false;
        }
        return true;
    }

    private HepRelVertex applyTransformationResults(HepRelVertex vertex, HepRuleCall call, @Nullable RelTrait parentTrait) {
        assert (!call.getResults().isEmpty());
        RelNode bestRel = null;
        if (call.getResults().size() == 1) {
            bestRel = call.getResults().get(0);
        } else {
            RelOptCost bestCost = null;
            RelMetadataQuery mq = call.getMetadataQuery();
            for (RelNode rel : call.getResults()) {
                RelOptCost thisCost = this.getCost(rel, mq);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("considering {} with cumulative cost={} and rowcount={}", new Object[]{rel, thisCost, mq.getRowCount(rel)});
                }
                if (thisCost == null || bestRel != null && !thisCost.isLt(Nullness.castNonNull(bestCost))) continue;
                bestRel = rel;
                bestCost = thisCost;
            }
        }
        ++this.nTransformations;
        this.notifyTransformation(call, Objects.requireNonNull(bestRel, "bestRel"), true);
        List<HepRelVertex> allParents = Graphs.predecessorListOf(this.graph, vertex);
        ArrayList<HepRelVertex> parents = new ArrayList<HepRelVertex>();
        for (HepRelVertex parent : allParents) {
            RelNode parentRel;
            if (parentTrait != null && ((parentRel = parent.getCurrentRel()) instanceof Converter || !parentRel.getTraitSet().contains(parentTrait))) continue;
            parents.add(parent);
        }
        HepRelVertex newVertex = this.addRelToGraph(bestRel);
        int iParentMatch = parents.indexOf(newVertex);
        if (iParentMatch != -1) {
            newVertex = (HepRelVertex)parents.get(iParentMatch);
        } else {
            this.contractVertices(newVertex, vertex, parents);
        }
        if (this.getListener() != null) {
            this.collectGarbage();
        }
        this.notifyTransformation(call, bestRel, false);
        this.dumpGraph();
        return newVertex;
    }

    @Override
    public RelNode register(RelNode rel, @Nullable RelNode equivRel) {
        return rel;
    }

    @Override
    public void onCopy(RelNode rel, RelNode newRel) {
        this.onCopyHook.apply(rel, newRel);
    }

    @Override
    public RelNode ensureRegistered(RelNode rel, @Nullable RelNode equivRel) {
        return rel;
    }

    @Override
    public boolean isRegistered(RelNode rel) {
        return true;
    }

    private HepRelVertex addRelToGraph(RelNode rel) {
        HepRelVertex equivVertex;
        if (this.graph.vertexSet().contains(rel)) {
            return (HepRelVertex)rel;
        }
        List<RelNode> inputs = rel.getInputs();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input1 : inputs) {
            HepRelVertex childVertex = this.addRelToGraph(input1);
            newInputs.add(childVertex);
        }
        if (!Util.equalShallow(inputs, newInputs)) {
            RelNode oldRel = rel;
            rel = rel.copy(rel.getTraitSet(), newInputs);
            this.onCopy(oldRel, rel);
        }
        rel.recomputeDigest();
        if (!this.noDag && (equivVertex = this.mapDigestToVertex.get(rel.getRelDigest())) != null) {
            return equivVertex;
        }
        HepRelVertex newVertex = new HepRelVertex(rel);
        this.graph.addVertex(newVertex);
        this.updateVertex(newVertex, rel);
        for (RelNode input : rel.getInputs()) {
            this.graph.addEdge(newVertex, (HepRelVertex)input);
        }
        ++this.nTransformations;
        return newVertex;
    }

    private void contractVertices(HepRelVertex preservedVertex, HepRelVertex discardedVertex, List<HepRelVertex> parents) {
        if (preservedVertex == discardedVertex) {
            return;
        }
        RelNode rel = preservedVertex.getCurrentRel();
        this.updateVertex(preservedVertex, rel);
        for (HepRelVertex parent : parents) {
            RelNode parentRel = parent.getCurrentRel();
            List<RelNode> inputs = parentRel.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                RelNode child = inputs.get(i);
                if (child != discardedVertex) continue;
                parentRel.replaceInput(i, preservedVertex);
            }
            this.clearCache(parent);
            this.graph.removeEdge(parent, discardedVertex);
            this.graph.addEdge(parent, preservedVertex);
            this.updateVertex(parent, parentRel);
        }
        if (discardedVertex == this.root) {
            this.root = preservedVertex;
        }
    }

    private void clearCache(HepRelVertex vertex) {
        RelMdUtil.clearCache(vertex.getCurrentRel());
        if (!RelMdUtil.clearCache(vertex)) {
            return;
        }
        ArrayDeque<DefaultEdge> queue = new ArrayDeque<DefaultEdge>(this.graph.getInwardEdges(vertex));
        while (!queue.isEmpty()) {
            DefaultEdge edge = (DefaultEdge)queue.remove();
            HepRelVertex source = (HepRelVertex)edge.source;
            RelMdUtil.clearCache(source.getCurrentRel());
            if (!RelMdUtil.clearCache(source)) continue;
            queue.addAll(this.graph.getInwardEdges(source));
        }
    }

    private void updateVertex(HepRelVertex vertex, RelNode rel) {
        RelDigest oldKey;
        if (rel != vertex.getCurrentRel()) {
            this.notifyDiscard(vertex.getCurrentRel());
        }
        if (this.mapDigestToVertex.get(oldKey = vertex.getCurrentRel().getRelDigest()) == vertex) {
            this.mapDigestToVertex.remove(oldKey);
        }
        this.mapDigestToVertex.put(rel.getRelDigest(), vertex);
        if (rel != vertex.getCurrentRel()) {
            vertex.replaceRel(rel);
        }
        this.notifyEquivalence(rel, vertex, false);
    }

    private RelNode buildFinalPlan(HepRelVertex vertex) {
        RelNode rel = vertex.getCurrentRel();
        this.notifyChosen(rel);
        List<RelNode> inputs = rel.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            RelNode child = inputs.get(i);
            if (!(child instanceof HepRelVertex)) continue;
            child = this.buildFinalPlan((HepRelVertex)child);
            rel.replaceInput(i, child);
        }
        RelMdUtil.clearCache(rel);
        rel.recomputeDigest();
        return rel;
    }

    private void collectGarbage() {
        if (this.nTransformations == this.nTransformationsLastGC) {
            return;
        }
        this.nTransformationsLastGC = this.nTransformations;
        LOGGER.trace("collecting garbage");
        HashSet rootSet = new HashSet();
        HepRelVertex root = Objects.requireNonNull(this.root, "this.root");
        if (this.graph.vertexSet().contains(root)) {
            BreadthFirstIterator.reachable(rootSet, this.graph, root);
        }
        if (rootSet.size() == this.graph.vertexSet().size()) {
            return;
        }
        HashSet<HepRelVertex> sweepSet = new HashSet<HepRelVertex>();
        for (HepRelVertex vertex : this.graph.vertexSet()) {
            if (rootSet.contains(vertex)) continue;
            sweepSet.add(vertex);
            RelNode rel = vertex.getCurrentRel();
            this.notifyDiscard(rel);
        }
        assert (!sweepSet.isEmpty());
        this.graph.removeAllVertices(sweepSet);
        this.graphSizeLastGC = this.graph.vertexSet().size();
        Iterator<Map.Entry<RelDigest, HepRelVertex>> digestIter = this.mapDigestToVertex.entrySet().iterator();
        while (digestIter.hasNext()) {
            HepRelVertex vertex;
            vertex = digestIter.next().getValue();
            if (!sweepSet.contains(vertex)) continue;
            digestIter.remove();
        }
    }

    private void assertNoCycles() {
        CycleDetector<HepRelVertex, DefaultEdge> cycleDetector = new CycleDetector<HepRelVertex, DefaultEdge>(this.graph);
        Set<HepRelVertex> cyclicVertices = cycleDetector.findCycles();
        if (cyclicVertices.isEmpty()) {
            return;
        }
        throw new AssertionError((Object)("Query graph cycle detected in HepPlanner: " + cyclicVertices));
    }

    private void dumpGraph() {
        if (!LOGGER.isTraceEnabled()) {
            return;
        }
        this.assertNoCycles();
        HepRelVertex root = this.root;
        if (root == null) {
            LOGGER.trace("dumpGraph: root is null");
            return;
        }
        RelMetadataQuery mq = root.getCluster().getMetadataQuery();
        StringBuilder sb = new StringBuilder();
        sb.append("\nBreadth-first from root:  {\n");
        for (HepRelVertex vertex : BreadthFirstIterator.of(this.graph, root)) {
            sb.append("    ").append(vertex).append(" = ");
            RelNode rel = vertex.getCurrentRel();
            sb.append(rel).append(", rowcount=").append(mq.getRowCount(rel)).append(", cumulative cost=").append(this.getCost(rel, mq)).append('\n');
        }
        sb.append("}");
        LOGGER.trace(sb.toString());
    }

    @Override
    @Deprecated
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
        list.add(0, new HepRelMetadataProvider());
    }

    @Override
    @Deprecated
    public long getRelMetadataTimestamp(RelNode rel) {
        return this.nTransformations;
    }

    public ImmutableList<RelOptMaterialization> getMaterializations() {
        return ImmutableList.copyOf(this.materializations);
    }

    @Override
    public void addMaterialization(RelOptMaterialization materialization) {
        this.materializations.add(materialization);
    }
}

