/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.linq4j;

import java.util.Arrays;
import org.apache.hive.druid.org.apache.calcite.linq4j.ModularInteger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MemoryFactory<E> {
    private final int history;
    private final int future;
    ModularInteger offset;
    private final @Nullable Object[] values;

    public MemoryFactory(int history, int future) {
        this.history = history;
        this.future = future;
        this.values = new Object[history + future + 1];
        this.offset = new ModularInteger(0, history + future + 1);
    }

    public void add(E current) {
        this.values[this.offset.get()] = current;
        this.offset = this.offset.plus(1);
    }

    public Memory<E> create() {
        return new Memory(this.history, this.future, this.offset, (Object[])this.values.clone());
    }

    public static class Memory<E> {
        private final int history;
        private final int future;
        private final ModularInteger offset;
        private final @Nullable Object[] values;

        public Memory(int history, int future, ModularInteger offset, @Nullable Object[] values) {
            this.history = history;
            this.future = future;
            this.offset = offset;
            this.values = values;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }

        public E get() {
            return this.get(0);
        }

        public E get(int position) {
            if (position < 0 && position < -1 * this.history) {
                throw new IllegalArgumentException("History can only go back " + this.history + " points in time, you wanted " + Math.abs(position));
            }
            if (position > 0 && position > this.future) {
                throw new IllegalArgumentException("Future can only see next " + this.future + " points in time, you wanted " + position);
            }
            return (E)this.values[this.offset.plus(position - 1 - this.future).get()];
        }
    }
}

