/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.cache.LoadingCache;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Function0;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Function1;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialectFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JdbcUtils {
    private JdbcUtils() {
        throw new AssertionError((Object)"no instances!");
    }

    static Function1<ResultSet, Function0<@Nullable Object[]>> rowBuilderFactory(List<Pair<ColumnMetaData.Rep, Integer>> list) {
        ColumnMetaData.Rep[] reps = Pair.left(list).toArray(new ColumnMetaData.Rep[0]);
        int[] types = Ints.toArray(Pair.right(list));
        return resultSet -> new ObjectArrayRowBuilder1((ResultSet)resultSet, reps, types);
    }

    static Function1<ResultSet, Function0<@Nullable Object[]>> rowBuilderFactory2(List<Pair<ColumnMetaData.Rep, Integer>> list) {
        ColumnMetaData.Rep[] reps = Pair.left(list).toArray(new ColumnMetaData.Rep[0]);
        int[] types = Ints.toArray(Pair.right(list));
        return resultSet -> new ObjectArrayRowBuilder2((ResultSet)resultSet, reps, types);
    }

    static class DataSourcePool {
        public static final DataSourcePool INSTANCE = new DataSourcePool();
        private final LoadingCache<List<@Nullable String>, BasicDataSource> cache = CacheBuilder.newBuilder().softValues().build(CacheLoader.from(DataSourcePool::dataSource));

        DataSourcePool() {
        }

        private static BasicDataSource dataSource(List<? extends @Nullable String> key) {
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setUrl(key.get(0));
            dataSource.setUsername(key.get(1));
            dataSource.setPassword(key.get(2));
            dataSource.setDriverClassName(key.get(3));
            return dataSource;
        }

        public DataSource get(String url, @Nullable String driverClassName, @Nullable String username, @Nullable String password) {
            List<@Nullable String> key = ImmutableNullableList.of(url, username, password, driverClassName);
            return this.cache.getUnchecked(key);
        }
    }

    static class ObjectArrayRowBuilder2
    extends ObjectArrayRowBuilder1 {
        ObjectArrayRowBuilder2(ResultSet resultSet, ColumnMetaData.Rep[] reps, int[] types) {
            super(resultSet, reps, types);
        }

        @Override
        protected @Nullable Object value(int i) throws SQLException {
            switch (this.types[i]) {
                case 93: {
                    Timestamp timestamp = this.resultSet.getTimestamp(i + 1);
                    return timestamp == null ? null : Long.valueOf(this.timestampToLong(timestamp));
                }
                case 92: {
                    Time time = this.resultSet.getTime(i + 1);
                    return time == null ? null : Integer.valueOf((int)this.timeToLong(time));
                }
                case 91: {
                    Date date = this.resultSet.getDate(i + 1);
                    return date == null ? null : Integer.valueOf((int)(this.dateToLong(date) / 86400000L));
                }
            }
            return this.reps[i].jdbcGet(this.resultSet, i + 1);
        }
    }

    static class ObjectArrayRowBuilder1
    extends ObjectArrayRowBuilder {
        final TimeZone timeZone = TimeZone.getDefault();

        ObjectArrayRowBuilder1(ResultSet resultSet, ColumnMetaData.Rep[] reps, int[] types) {
            super(resultSet, reps, types);
        }

        @Override
        protected @Nullable Object value(int i) throws SQLException {
            switch (this.types[i]) {
                case 93: {
                    Timestamp timestamp = this.resultSet.getTimestamp(i + 1);
                    return timestamp == null ? null : new Timestamp(this.timestampToLong(timestamp));
                }
                case 92: {
                    Time time = this.resultSet.getTime(i + 1);
                    return time == null ? null : new Time(this.timeToLong(time));
                }
                case 91: {
                    Date date = this.resultSet.getDate(i + 1);
                    return date == null ? null : new Date(this.dateToLong(date));
                }
            }
            return this.reps[i].jdbcGet(this.resultSet, i + 1);
        }

        @Override
        long timestampToLong(Timestamp v) {
            long time = v.getTime();
            int offset = this.timeZone.getOffset(time);
            return time + (long)offset;
        }

        @Override
        long timeToLong(Time v) {
            long time = v.getTime();
            int offset = this.timeZone.getOffset(time);
            return (time + (long)offset) % 86400000L;
        }

        @Override
        long dateToLong(Date v) {
            long time = v.getTime();
            int offset = this.timeZone.getOffset(time);
            return time + (long)offset;
        }
    }

    static abstract class ObjectArrayRowBuilder
    implements Function0<Object[]> {
        protected final ResultSet resultSet;
        protected final int columnCount;
        protected final ColumnMetaData.Rep[] reps;
        protected final int[] types;

        ObjectArrayRowBuilder(ResultSet resultSet, ColumnMetaData.Rep[] reps, int[] types) {
            this.resultSet = resultSet;
            this.reps = reps;
            this.types = types;
            try {
                this.columnCount = resultSet.getMetaData().getColumnCount();
            }
            catch (SQLException e) {
                throw Util.throwAsRuntime(e);
            }
        }

        @Override
        public @Nullable Object[] apply() {
            try {
                @Nullable Object[] values = new Object[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    values[i] = this.value(i);
                }
                return values;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract @Nullable Object value(int var1) throws SQLException;

        long timestampToLong(Timestamp v) {
            return v.getTime();
        }

        long timeToLong(Time v) {
            return v.getTime();
        }

        long dateToLong(Date v) {
            return v.getTime();
        }
    }

    static class DialectPool {
        public static final DialectPool INSTANCE = new DialectPool();
        private final LoadingCache<Pair<SqlDialectFactory, DataSource>, SqlDialect> cache = CacheBuilder.newBuilder().softValues().build(CacheLoader.from(DialectPool::dialect));

        DialectPool() {
        }

        private static SqlDialect dialect(Pair<SqlDialectFactory, DataSource> key) {
            SqlDialectFactory dialectFactory = (SqlDialectFactory)key.left;
            DataSource dataSource = (DataSource)key.right;
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                SqlDialect dialect = dialectFactory.create(metaData);
                connection.close();
                connection = null;
                SqlDialect sqlDialect = dialect;
                return sqlDialect;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }

        public SqlDialect get(SqlDialectFactory dialectFactory, DataSource dataSource) {
            Pair<SqlDialectFactory, DataSource> key = Pair.of(dialectFactory, dataSource);
            return this.cache.getUnchecked(key);
        }
    }
}

