/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Sort;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableLimitSort
extends Sort
implements EnumerableRel {
    public EnumerableLimitSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, input, collation, offset, fetch);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableLimitSort create(RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace(collation);
        return new EnumerableLimitSort(cluster, traitSet, input, collation, offset, fetch);
    }

    @Override
    public EnumerableLimitSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new EnumerableLimitSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression childExp = builder.append("child", result.block);
        PhysType inputPhysType = result.physType;
        Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(this.collation.getFieldCollations());
        Expression fetchVal = this.fetch == null ? Expressions.constant(Integer.MAX_VALUE) : EnumerableLimit.getExpression(this.fetch);
        Expression offsetVal = this.offset == null ? Expressions.constant(0) : EnumerableLimit.getExpression(this.offset);
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.ORDER_BY_WITH_FETCH_AND_OFFSET.method, Expressions.list(childExp, builder.append("keySelector", (Expression)pair.left)).appendIfNotNull(builder.appendIfNotNull("comparator", (Expression)pair.right)).appendIfNotNull(builder.appendIfNotNull("offset", Expressions.constant(offsetVal))).appendIfNotNull(builder.appendIfNotNull("fetch", Expressions.constant(fetchVal))))));
        return implementor.result(physType, builder.toBlock());
    }
}

