/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NaryOperatorConverter
implements DruidSqlOperatorConverter {
    private final SqlOperator operator;
    private final String druidOperatorName;

    public NaryOperatorConverter(SqlOperator operator, String druidOperatorName) {
        this.operator = Objects.requireNonNull(operator, "operator");
        this.druidOperatorName = Objects.requireNonNull(druidOperatorName, "druidOperatorName");
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public @Nullable String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexCall call = (RexCall)rexNode;
        List<String> druidExpressions = DruidExpressions.toDruidExpressions(druidQuery, rowType, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return DruidExpressions.nAryOperatorCall(this.druidOperatorName, druidExpressions);
    }
}

