/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DruidQueryRecordReader<R extends Comparable<R>>
extends RecordReader<NullWritable, DruidWritable>
implements org.apache.hadoop.mapred.RecordReader<NullWritable, DruidWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(DruidQueryRecordReader.class);
    private final Object initLock = new Object();
    private ObjectMapper smileMapper;
    private Configuration conf;
    private String[] locations;
    private HttpClient httpClient;
    protected Query query;
    private volatile JsonParserIterator<R> queryResultsIterator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonParserIterator<R> getQueryResultsIterator() {
        if (this.queryResultsIterator == null) {
            Object object = this.initLock;
            synchronized (object) {
                if (this.queryResultsIterator == null) {
                    this.queryResultsIterator = this.createQueryResultsIterator();
                }
            }
        }
        return this.queryResultsIterator;
    }

    public JsonParserIterator<R> createQueryResultsIterator() {
        JsonParserIterator iterator = null;
        String filterExprSerialized = this.conf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized != null) {
            ExprNodeGenericFuncDesc filterExpr = SerializationUtilities.deserializeExpression((String)filterExprSerialized);
            this.query = DruidStorageHandlerUtils.addDynamicFilters(this.query, filterExpr, this.conf, true);
        }
        JavaType resultsType = this.getResultTypeDef();
        boolean initialized = false;
        int currentLocationIndex = 0;
        Exception ex = null;
        while (!initialized && currentLocationIndex < this.locations.length) {
            String address;
            if (Strings.isNullOrEmpty((String)(address = this.locations[currentLocationIndex++]))) {
                throw new RE("can not fetch results from empty or null host value", new Object[0]);
            }
            LOG.debug("Retrieving data from druid location[{}] using query:[{}] ", (Object)address, (Object)this.query);
            try {
                Request request = DruidStorageHandlerUtils.createSmileRequest(address, this.query);
                ListenableFuture<InputStream> inputStreamFuture = this.httpClient.go(request, new InputStreamResponseHandler());
                iterator = new JsonParserIterator(this, this.smileMapper, resultsType, inputStreamFuture, request.getUrl().toString(), this.query);
                iterator.init();
                initialized = true;
            }
            catch (Exception e) {
                if (iterator != null) {
                    CloseQuietly.close(iterator);
                }
                LOG.error("Failure getting results for query[{}] from host[{}] because of [{}]", new Object[]{this.query, address, e.getMessage()});
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (!initialized) {
            throw new RE(ex, "Failure getting results for query[%s] from locations[%s] because of [%s]", this.query, this.locations, ((Exception)Objects.requireNonNull(ex)).getMessage());
        }
        return iterator;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.initialize(split, context.getConfiguration());
    }

    public void initialize(InputSplit split, ObjectMapper mapper, ObjectMapper smileMapper, HttpClient httpClient, Configuration conf) throws IOException {
        this.conf = conf;
        HiveDruidSplit hiveDruidSplit = (HiveDruidSplit)split;
        Preconditions.checkNotNull(hiveDruidSplit, "input split is null ???");
        Preconditions.checkNotNull(httpClient, "need Http Client can not be null");
        this.smileMapper = Preconditions.checkNotNull(smileMapper, "Smile Mapper can not be null");
        this.query = mapper.readValue(Preconditions.checkNotNull(hiveDruidSplit.getDruidQuery()), Query.class);
        Preconditions.checkNotNull(this.query);
        this.locations = hiveDruidSplit.getLocations();
        this.httpClient = httpClient;
    }

    public void initialize(InputSplit split, Configuration conf) throws IOException {
        this.initialize(split, DruidStorageHandlerUtils.JSON_MAPPER, DruidStorageHandlerUtils.SMILE_MAPPER, DruidStorageHandler.getHttpClient(), conf);
    }

    protected abstract JavaType getResultTypeDef();

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public DruidWritable createValue() {
        return new DruidWritable(false);
    }

    public abstract boolean next(NullWritable var1, DruidWritable var2) throws IOException;

    public long getPos() {
        return -1L;
    }

    public abstract boolean nextKeyValue() throws IOException;

    public abstract NullWritable getCurrentKey() throws IOException, InterruptedException;

    public abstract DruidWritable getCurrentValue() throws IOException, InterruptedException;

    public abstract float getProgress() throws IOException;

    public void close() {
        if (this.queryResultsIterator != null) {
            CloseQuietly.close(this.queryResultsIterator);
        }
    }

    protected class JsonParserIterator<R extends Comparable<R>>
    implements Iterator<R>,
    Closeable {
        private JsonParser jp;
        private ObjectCodec objectCodec;
        private final ObjectMapper mapper;
        private final JavaType typeRef;
        private final Future<InputStream> future;
        private final Query query;
        private final String url;

        JsonParserIterator(DruidQueryRecordReader this$0, ObjectMapper mapper, JavaType typeRef, Future<InputStream> future, String url, Query query) {
            this.typeRef = typeRef;
            this.future = future;
            this.url = url;
            this.query = query;
            this.mapper = mapper;
            this.jp = null;
        }

        @Override
        public boolean hasNext() {
            if (this.jp.isClosed()) {
                return false;
            }
            if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
                CloseQuietly.close(this.jp);
                return false;
            }
            return true;
        }

        @Override
        public R next() {
            try {
                Comparable retVal = (Comparable)this.objectCodec.readValue(this.jp, this.typeRef);
                this.jp.nextToken();
                return (R)retVal;
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            if (this.jp == null) {
                try {
                    InputStream is = this.future.get();
                    if (is == null) {
                        throw new IOException(String.format("query[%s] url[%s] timed out", this.query, this.url));
                    }
                    this.jp = this.mapper.getFactory().createParser(is).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
                    JsonToken nextToken = this.jp.nextToken();
                    if (nextToken == JsonToken.START_OBJECT) {
                        QueryInterruptedException cause = this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class);
                        throw new QueryInterruptedException(cause);
                    }
                    if (nextToken != JsonToken.START_ARRAY) {
                        throw new IAE("Next token wasn't a START_ARRAY, was[%s] from url [%s]", new Object[]{this.jp.getCurrentToken(), this.url});
                    }
                    this.jp.nextToken();
                    this.objectCodec = this.jp.getCodec();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RE(e, "Failure getting results for query[%s] url[%s] because of [%s]", this.query, this.url, e.getMessage());
                }
            }
        }

        @Override
        public void close() throws IOException {
            CloseQuietly.close(this.jp);
        }
    }
}

