/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidKerberosUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidKerberosUtil.class);
    private static final ReentrantLock KERBEROS_LOCK = new ReentrantLock(true);

    private DruidKerberosUtil() {
    }

    static String kerberosChallenge(String server) throws AuthenticationException {
        KERBEROS_LOCK.lock();
        try {
            Oid mechOid = KerberosUtil.getOidInstance((String)"GSS_KRB5_MECH_OID");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gssContext = manager.createContext(serverName.canonicalize(mechOid), mechOid, null, 0);
            gssContext.requestMutualAuth(true);
            gssContext.requestCredDeleg(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            LOG.debug("Got valid challenge for host {}", (Object)serverName);
            String string = Base64.getEncoder().encodeToString(outToken);
            return string;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | GSSException e) {
            throw new AuthenticationException((Throwable)e);
        }
        finally {
            KERBEROS_LOCK.unlock();
        }
    }

    static HttpCookie getAuthCookie(CookieStore cookieStore, URI uri) {
        if (cookieStore == null) {
            return null;
        }
        boolean isSSL = uri.getScheme().equals("https");
        List<HttpCookie> cookies = cookieStore.getCookies();
        for (HttpCookie c : cookies) {
            if (c.getSecure() && !isSSL || !c.getName().equals("hadoop.auth")) continue;
            return c;
        }
        return null;
    }

    static void removeAuthCookie(CookieStore cookieStore, URI uri) {
        HttpCookie authCookie = DruidKerberosUtil.getAuthCookie(cookieStore, uri);
        if (authCookie != null) {
            cookieStore.remove(uri, authCookie);
        }
    }

    static boolean needToSendCredentials(CookieStore cookieStore, URI uri) {
        return DruidKerberosUtil.getAuthCookie(cookieStore, uri) == null;
    }
}

