/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.indexing.TuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Period;

public abstract class SeekableStreamIndexTaskTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final boolean DEFAULT_RESET_OFFSET_AUTOMATICALLY = false;
    private static final boolean DEFAULT_SKIP_SEQUENCE_NUMBER_AVAILABILITY_CHECK = false;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final DynamicPartitionsSpec partitionsSpec;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    @Deprecated
    private final int maxPendingPersists;
    private final IndexSpec indexSpec;
    private final IndexSpec indexSpecForIntermediatePersists;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;
    private final boolean resetOffsetAutomatically;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private final Period intermediateHandoffPeriod;
    private final boolean skipSequenceNumberAvailabilityCheck;
    private final boolean logParseExceptions;
    private final int maxParseExceptions;
    private final int maxSavedParseExceptions;

    public SeekableStreamIndexTaskTuningConfig(@Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows, @Nullable Period intermediatePersistPeriod, @Nullable File basePersistDirectory, @Nullable Integer maxPendingPersists, @Nullable IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, @Deprecated @JsonProperty(value="buildV9Directly") @Nullable Boolean buildV9Directly, @Deprecated @Nullable Boolean reportParseExceptions, @Nullable Long handoffConditionTimeout, @Nullable Boolean resetOffsetAutomatically, Boolean skipSequenceNumberAvailabilityCheck, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Period intermediateHandoffPeriod, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions) {
        RealtimeTuningConfig defaults = RealtimeTuningConfig.makeDefaultTuningConfig(basePersistDirectory);
        this.maxRowsInMemory = maxRowsInMemory == null ? defaults.getMaxRowsInMemory() : maxRowsInMemory.intValue();
        this.partitionsSpec = new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaults.getIntermediatePersistPeriod() : intermediatePersistPeriod;
        this.basePersistDirectory = defaults.getBasePersistDirectory();
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.indexSpec = indexSpec == null ? defaults.getIndexSpec() : indexSpec;
        this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
        this.reportParseExceptions = reportParseExceptions == null ? defaults.isReportParseExceptions() : reportParseExceptions.booleanValue();
        this.handoffConditionTimeout = handoffConditionTimeout == null ? defaults.getHandoffConditionTimeout() : handoffConditionTimeout.longValue();
        this.resetOffsetAutomatically = resetOffsetAutomatically == null ? false : resetOffsetAutomatically;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.intermediateHandoffPeriod = intermediateHandoffPeriod == null ? new Period().withDays(Integer.MAX_VALUE) : intermediateHandoffPeriod;
        boolean bl = this.skipSequenceNumberAvailabilityCheck = skipSequenceNumberAvailabilityCheck == null ? false : skipSequenceNumberAvailabilityCheck;
        if (this.reportParseExceptions) {
            this.maxParseExceptions = 0;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
        } else {
            this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
        }
        this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
    }

    @Override
    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @Override
    @JsonProperty
    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @Override
    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.partitionsSpec.getMaxRowsPerSegment();
    }

    @Override
    @JsonProperty
    @Nullable
    public Long getMaxTotalRows() {
        return this.partitionsSpec.getMaxTotalRows();
    }

    @Override
    public DynamicPartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @Override
    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @Override
    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @Override
    @JsonProperty
    @Deprecated
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.indexSpecForIntermediatePersists;
    }

    @Deprecated
    @JsonProperty
    public boolean getBuildV9Directly() {
        return true;
    }

    @Override
    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public boolean isResetOffsetAutomatically() {
        return this.resetOffsetAutomatically;
    }

    @Override
    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @JsonProperty
    public Period getIntermediateHandoffPeriod() {
        return this.intermediateHandoffPeriod;
    }

    @JsonProperty
    public boolean isLogParseExceptions() {
        return this.logParseExceptions;
    }

    @JsonProperty
    public int getMaxParseExceptions() {
        return this.maxParseExceptions;
    }

    @JsonProperty
    public int getMaxSavedParseExceptions() {
        return this.maxSavedParseExceptions;
    }

    @JsonProperty
    public boolean isSkipSequenceNumberAvailabilityCheck() {
        return this.skipSequenceNumberAvailabilityCheck;
    }

    @Override
    public abstract SeekableStreamIndexTaskTuningConfig withBasePersistDirectory(File var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeekableStreamIndexTaskTuningConfig that = (SeekableStreamIndexTaskTuningConfig)o;
        return this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.maxPendingPersists == that.maxPendingPersists && this.reportParseExceptions == that.reportParseExceptions && this.handoffConditionTimeout == that.handoffConditionTimeout && this.resetOffsetAutomatically == that.resetOffsetAutomatically && this.skipSequenceNumberAvailabilityCheck == that.skipSequenceNumberAvailabilityCheck && this.logParseExceptions == that.logParseExceptions && this.maxParseExceptions == that.maxParseExceptions && this.maxSavedParseExceptions == that.maxSavedParseExceptions && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.intermediatePersistPeriod, that.intermediatePersistPeriod) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory) && Objects.equals(this.intermediateHandoffPeriod, that.intermediateHandoffPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.maxRowsInMemory, this.maxBytesInMemory, this.partitionsSpec, this.intermediatePersistPeriod, this.basePersistDirectory, this.maxPendingPersists, this.indexSpec, this.indexSpecForIntermediatePersists, this.reportParseExceptions, this.handoffConditionTimeout, this.resetOffsetAutomatically, this.segmentWriteOutMediumFactory, this.intermediateHandoffPeriod, this.skipSequenceNumberAvailabilityCheck, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
    }

    public abstract String toString();
}

