/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.util.Map;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorIOConfig;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorTuningConfig;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="kafka", value=KafkaSupervisorSpec.class)})
public class KafkaSupervisorSpec {
    private final DataSchema dataSchema;
    private final KafkaSupervisorTuningConfig tuningConfig;
    private final KafkaSupervisorIOConfig ioConfig;
    private final Map<String, Object> context;

    @JsonCreator
    public KafkaSupervisorSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KafkaSupervisorTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KafkaSupervisorIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context) {
        this.dataSchema = Preconditions.checkNotNull(dataSchema, "dataSchema");
        this.tuningConfig = tuningConfig != null ? tuningConfig : new KafkaSupervisorTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.ioConfig = Preconditions.checkNotNull(ioConfig, "ioConfig");
        this.context = context;
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public KafkaSupervisorTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public KafkaSupervisorIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public String toString() {
        return "KafkaSupervisorSpec{dataSchema=" + String.valueOf(this.dataSchema) + ", tuningConfig=" + String.valueOf(this.tuningConfig) + ", ioConfig=" + String.valueOf(this.ioConfig) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSupervisorSpec that = (KafkaSupervisorSpec)o;
        if (this.dataSchema != null ? !this.dataSchema.equals(that.dataSchema) : that.dataSchema != null) {
            return false;
        }
        if (this.tuningConfig != null ? !this.tuningConfig.equals(that.tuningConfig) : that.tuningConfig != null) {
            return false;
        }
        if (this.ioConfig != null ? !this.ioConfig.equals(that.ioConfig) : that.ioConfig != null) {
            return false;
        }
        return this.context != null ? this.context.equals(that.context) : that.context == null;
    }

    public int hashCode() {
        int result = this.dataSchema != null ? this.dataSchema.hashCode() : 0;
        result = 31 * result + (this.tuningConfig != null ? this.tuningConfig.hashCode() : 0);
        result = 31 * result + (this.ioConfig != null ? this.ioConfig.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }
}

