/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.hive.druid.json.AvroBytesDecoder;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.ByteBufferInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;

public class AvroStreamInputRowParser
implements ByteBufferInputRowParser {
    private final ParseSpec parseSpec;
    private final AvroBytesDecoder avroBytesDecoder;

    @JsonCreator
    public AvroStreamInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="avroBytesDecoder") AvroBytesDecoder avroBytesDecoder) {
        this.parseSpec = Preconditions.checkNotNull(parseSpec, "parseSpec");
        this.avroBytesDecoder = Preconditions.checkNotNull(avroBytesDecoder, "avroBytesDecoder");
    }

    @Override
    @NotNull
    public List<InputRow> parseBatch(ByteBuffer input) {
        throw new UnsupportedOperationException("This class is only used for JSON serde");
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public AvroBytesDecoder getAvroBytesDecoder() {
        return this.avroBytesDecoder;
    }

    @Override
    public ByteBufferInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new AvroStreamInputRowParser(parseSpec, this.avroBytesDecoder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroStreamInputRowParser that = (AvroStreamInputRowParser)o;
        return Objects.equals(this.parseSpec, that.parseSpec) && Objects.equals(this.avroBytesDecoder, that.avroBytesDecoder);
    }

    public int hashCode() {
        return Objects.hash(this.parseSpec, this.avroBytesDecoder);
    }
}

