/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidKafkaUtils;
import org.apache.hadoop.hive.druid.DruidStorageHandlerInfo;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.DruidOutputFormat;
import org.apache.hadoop.hive.druid.io.DruidQueryBasedInputFormat;
import org.apache.hadoop.hive.druid.io.DruidRecordWriter;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorReport;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorSpec;
import org.apache.hadoop.hive.druid.security.KerberosHttpClient;
import org.apache.hadoop.hive.druid.serde.DruidSerDe;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.storage.derby.DerbyConnector;
import org.apache.hive.druid.org.apache.druid.metadata.storage.derby.DerbyMetadataStorage;
import org.apache.hive.druid.org.apache.druid.metadata.storage.mysql.MySQLConnector;
import org.apache.hive.druid.org.apache.druid.metadata.storage.mysql.MySQLConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.storage.postgresql.PostgreSQLConnector;
import org.apache.hive.druid.org.apache.druid.metadata.storage.postgresql.PostgreSQLConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.storage.postgresql.PostgreSQLTablesConfig;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidStorageHandler
extends DefaultHiveMetaHook
implements HiveStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DruidStorageHandler.class);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    public static final String SEGMENTS_DESCRIPTOR_DIR_NAME = "segmentsDescriptorDir";
    private static final String INTERMEDIATE_SEGMENT_DIR_NAME = "intermediateSegmentDir";
    private static final HttpClient HTTP_CLIENT;
    private static final List<String> ALLOWED_ALTER_TYPES;
    private static final String DRUID_PREFIX = "druid:";
    private static final String DRUID_HOST_NAME = "druid.zk.service.host";
    private SQLMetadataConnector connector;
    private MetadataStorageTablesConfig druidMetadataStorageTablesConfig = null;
    private String uniqueId = null;
    private String rootWorkingDir = null;
    private Configuration conf;

    public DruidStorageHandler() {
    }

    @VisibleForTesting
    public DruidStorageHandler(SQLMetadataConnector connector, MetadataStorageTablesConfig druidMetadataStorageTablesConfig) {
        this.connector = connector;
        this.druidMetadataStorageTablesConfig = druidMetadataStorageTablesConfig;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return DruidQueryBasedInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return DruidOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return DruidSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return new DefaultHiveAuthorizationProvider();
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> jobSecrets) {
    }

    public void preCreateTable(Table table) throws MetaException {
        if (!StringUtils.isEmpty(table.getSd().getLocation())) {
            throw new MetaException("LOCATION may not be specified for Druid");
        }
        if (table.getPartitionKeysSize() != 0) {
            throw new MetaException("PARTITIONED BY may not be specified for Druid");
        }
        if (table.getSd().getBucketColsSize() != 0) {
            throw new MetaException("CLUSTERED BY may not be specified for Druid");
        }
        String dataSourceName = (String)table.getParameters().get("druid.datasource");
        if (dataSourceName != null) {
            return;
        }
        dataSourceName = TableName.getDbTable((String)table.getDbName(), (String)table.getTableName());
        try {
            this.getConnector().createSegmentTable();
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create druid segments table", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        Collection<String> existingDataSources = DruidStorageHandlerUtils.getAllDataSourceNames(this.getConnector(), this.getDruidMetadataStorageTablesConfig());
        LOG.debug("pre-create data source with name {}", (Object)dataSourceName);
        if (existingDataSources.contains(dataSourceName)) {
            throw new MetaException(String.format("Data source [%s] already existing", dataSourceName));
        }
        table.getParameters().put("druid.datasource", dataSourceName);
    }

    public void rollbackCreateTable(Table table) {
        this.cleanWorkingDir();
    }

    public void commitCreateTable(Table table) throws MetaException {
        if (DruidKafkaUtils.isKafkaStreamingTable(table)) {
            this.updateKafkaIngestion(table);
        }
        this.commitInsertTable(table, false);
    }

    public URI getURIForAuth(Table table) throws URISyntaxException {
        Map tableProperties = HiveCustomStorageHandlerUtils.getTableProperties((Table)table);
        String host_name = this.conf.get(DRUID_HOST_NAME) != null ? this.conf.get(DRUID_HOST_NAME) : HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
        String table_name = (String)tableProperties.get("druid.datasource");
        String column_names = (String)tableProperties.get("druid.fieldNames");
        if (column_names != null) {
            return new URI("druid://" + host_name + "/" + table_name + "/" + column_names);
        }
        return new URI("druid://" + host_name + "/" + table_name);
    }

    private void updateKafkaIngestion(Table table) {
        String overlordAddress = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_OVERLORD_DEFAULT_ADDRESS);
        String dataSourceName = Preconditions.checkNotNull(DruidStorageHandlerUtils.getTableProperty(table, "druid.datasource"), "Druid datasource name is null");
        String kafkaTopic = Preconditions.checkNotNull(DruidStorageHandlerUtils.getTableProperty(table, "kafka.topic"), "kafka topic is null");
        String kafkaServers = Preconditions.checkNotNull(DruidStorageHandlerUtils.getTableProperty(table, "kafka.bootstrap.servers"), "kafka connect string is null");
        Properties tableProperties = new Properties();
        tableProperties.putAll((Map<?, ?>)table.getParameters());
        GranularitySpec granularitySpec = DruidStorageHandlerUtils.getGranularitySpec(this.getConf(), tableProperties);
        List columns = table.getSd().getCols();
        ArrayList<String> columnNames = new ArrayList<String>(columns.size());
        ArrayList<TypeInfo> columnTypes = new ArrayList<TypeInfo>(columns.size());
        for (FieldSchema schema : columns) {
            columnNames.add(schema.getName());
            columnTypes.add(TypeInfoUtils.getTypeInfoFromTypeString((String)schema.getType()));
        }
        Pair<List<DimensionSchema>, AggregatorFactory[]> dimensionsAndAggregates = DruidStorageHandlerUtils.getDimensionsAndAggregates(columnNames, columnTypes);
        if (!columnNames.contains("__time")) {
            throw new IllegalStateException("Timestamp column (' __time') not specified in create table; list of columns is : " + String.valueOf(columnNames));
        }
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)dimensionsAndAggregates.lhs, null, null);
        String timestampFormat = DruidStorageHandlerUtils.getTableProperty(table, "druid.timestamp.format");
        String timestampColumnName = DruidStorageHandlerUtils.getTableProperty(table, "druid.timestamp.column");
        if (timestampColumnName == null) {
            timestampColumnName = "__time";
        }
        TimestampSpec timestampSpec = new TimestampSpec(timestampColumnName, timestampFormat, null);
        InputRowParser inputRowParser = DruidKafkaUtils.getInputRowParser(table, timestampSpec, dimensionsSpec);
        Map<String, Object> inputParser = DruidStorageHandlerUtils.JSON_MAPPER.convertValue((Object)inputRowParser, new TypeReference<Map<String, Object>>(this){});
        DataSchema dataSchema = new DataSchema(dataSourceName, inputParser, (AggregatorFactory[])dimensionsAndAggregates.rhs, granularitySpec, null, DruidStorageHandlerUtils.JSON_MAPPER);
        IndexSpec indexSpec = DruidStorageHandlerUtils.getIndexSpec(this.getConf());
        KafkaSupervisorSpec spec = DruidKafkaUtils.createKafkaSupervisorSpec(table, kafkaTopic, kafkaServers, dataSchema, indexSpec);
        KafkaSupervisorSpec existingSpec = this.fetchKafkaIngestionSpec(table);
        String targetState = DruidStorageHandlerUtils.getTableProperty(table, "druid.kafka.ingestion");
        if (targetState == null) {
            String string = targetState = existingSpec == null ? "STOP" : "START";
        }
        if ("STOP".equalsIgnoreCase(targetState)) {
            if (existingSpec != null) {
                this.stopKafkaIngestion(overlordAddress, dataSourceName);
            }
        } else if ("START".equalsIgnoreCase(targetState)) {
            if (existingSpec == null || !existingSpec.equals(spec)) {
                DruidKafkaUtils.updateKafkaIngestionSpec(overlordAddress, spec);
            }
        } else if ("RESET".equalsIgnoreCase(targetState)) {
            if (existingSpec != null && !existingSpec.equals(spec)) {
                DruidKafkaUtils.updateKafkaIngestionSpec(overlordAddress, spec);
            }
            this.resetKafkaIngestion(overlordAddress, dataSourceName);
        } else {
            throw new IllegalArgumentException(String.format("Invalid value for property [%s], Valid values are [START, STOP, RESET]", "druid.kafka.ingestion"));
        }
        table.getParameters().remove("druid.kafka.ingestion");
    }

    private void resetKafkaIngestion(String overlordAddress, String dataSourceName) {
        try {
            StringFullResponseHolder response = RetryUtils.retry(() -> DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.POST, new URL(String.format("http://%s/druid/indexer/v1/supervisor/%s/reset", overlordAddress, dataSourceName))), new StringFullResponseHandler(Charset.forName("UTF-8"))), input -> input instanceof IOException, this.getMaxRetryCount());
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new IOException(String.format("Unable to reset Kafka Ingestion Druid status [%d] full response [%s]", response.getStatus().getCode(), response.getContent()));
            }
            CONSOLE.printInfo("Druid Kafka Ingestion Reset successful.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void stopKafkaIngestion(String overlordAddress, String dataSourceName) {
        try {
            StringFullResponseHolder response = RetryUtils.retry(() -> DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.POST, new URL(String.format("http://%s/druid/indexer/v1/supervisor/%s/shutdown", overlordAddress, dataSourceName))), new StringFullResponseHandler(Charset.forName("UTF-8"))), input -> input instanceof IOException, this.getMaxRetryCount());
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new IOException(String.format("Unable to stop Kafka Ingestion Druid status [%d] full response [%s]", response.getStatus().getCode(), response.getContent()));
            }
            CONSOLE.printInfo("Druid Kafka Ingestion shutdown successful.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KafkaSupervisorSpec fetchKafkaIngestionSpec(Table table) {
        String overlordAddress = Preconditions.checkNotNull(HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_OVERLORD_DEFAULT_ADDRESS), "Druid Overlord Address is null");
        String dataSourceName = Preconditions.checkNotNull(DruidStorageHandlerUtils.getTableProperty(table, "druid.datasource"), "Druid Datasource name is null");
        try {
            StringFullResponseHolder response = RetryUtils.retry(() -> DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.GET, new URL(String.format("http://%s/druid/indexer/v1/supervisor/%s", overlordAddress, dataSourceName))), new StringFullResponseHandler(Charset.forName("UTF-8"))), input -> input instanceof IOException, this.getMaxRetryCount());
            if (response.getStatus().equals(HttpResponseStatus.OK)) {
                return DruidStorageHandlerUtils.JSON_MAPPER.readValue(response.getContent(), KafkaSupervisorSpec.class);
            }
            if (response.getStatus().equals(HttpResponseStatus.NOT_FOUND) || response.getStatus().equals(HttpResponseStatus.BAD_REQUEST)) {
                LOG.debug("No Kafka Supervisor found for datasource[%s]", (Object)dataSourceName);
                return null;
            }
            throw new IOException(String.format("Unable to fetch Kafka Ingestion Spec from Druid status [%d] full response [%s]", response.getStatus().getCode(), response.getContent()));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while fetching kafka ingestion spec from druid", e);
        }
    }

    @Nullable
    private KafkaSupervisorReport fetchKafkaSupervisorReport(Table table) {
        String overlordAddress = Preconditions.checkNotNull(HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_OVERLORD_DEFAULT_ADDRESS), "Druid Overlord Address is null");
        String dataSourceName = Preconditions.checkNotNull(DruidStorageHandlerUtils.getTableProperty(table, "druid.datasource"), "Druid Datasource name is null");
        try {
            StringFullResponseHolder response = RetryUtils.retry(() -> DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.GET, new URL(String.format("http://%s/druid/indexer/v1/supervisor/%s/status", overlordAddress, dataSourceName))), new StringFullResponseHandler(Charset.forName("UTF-8"))), input -> input instanceof IOException, this.getMaxRetryCount());
            if (response.getStatus().equals(HttpResponseStatus.OK)) {
                return DruidStorageHandlerUtils.JSON_MAPPER.readValue(response.getContent(), KafkaSupervisorReport.class);
            }
            if (response.getStatus().equals(HttpResponseStatus.NOT_FOUND) || response.getStatus().equals(HttpResponseStatus.BAD_REQUEST)) {
                LOG.info("No Kafka Supervisor found for datasource[%s]", (Object)dataSourceName);
                return null;
            }
            LOG.error("Unable to fetch Kafka Supervisor status [%d] full response [%s]", (Object)response.getStatus().getCode(), (Object)response.getContent());
            return null;
        }
        catch (Exception e) {
            LOG.error("Exception while fetching kafka ingestion spec from druid", (Throwable)e);
            return null;
        }
    }

    private List<DataSegment> loadAndCommitDruidSegments(Table table, boolean overwrite, List<DataSegment> segmentsToLoad) throws IOException, CallbackFailedException {
        String dataSourceName = (String)table.getParameters().get("druid.datasource");
        String segmentDirectory = table.getParameters().get("druid.storage.storageDirectory") != null ? (String)table.getParameters().get("druid.storage.storageDirectory") : HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY);
        HdfsDataSegmentPusherConfig hdfsSegmentPusherConfig = new HdfsDataSegmentPusherConfig();
        LOG.info(String.format("Moving [%s] Druid segments from staging directory [%s] to Deep storage [%s]", segmentsToLoad.size(), this.getStagingWorkingDir().toString(), segmentDirectory));
        hdfsSegmentPusherConfig.setStorageDirectory(segmentDirectory);
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(hdfsSegmentPusherConfig, this.getConf(), DruidStorageHandlerUtils.JSON_MAPPER);
        List<DataSegment> publishedDataSegmentList = DruidStorageHandlerUtils.publishSegmentsAndCommit(this.getConnector(), this.getDruidMetadataStorageTablesConfig(), dataSourceName, segmentsToLoad, overwrite, this.getConf(), dataSegmentPusher);
        return publishedDataSegmentList;
    }

    private void checkLoadStatus(List<DataSegment> segments) {
        String coordinatorResponse;
        String coordinatorAddress = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_COORDINATOR_DEFAULT_ADDRESS);
        int maxTries = this.getMaxRetryCount();
        LOG.debug("checking load status from coordinator {}", (Object)coordinatorAddress);
        try {
            coordinatorResponse = RetryUtils.retry(() -> DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.GET, new URL(String.format("http://%s/status", coordinatorAddress))), new StringFullResponseHandler(Charset.forName("UTF-8"))).getContent(), input -> input instanceof IOException, maxTries);
        }
        catch (Exception e) {
            CONSOLE.printInfo("Will skip waiting for data loading, coordinator unavailable");
            return;
        }
        if (Strings.isNullOrEmpty(coordinatorResponse)) {
            CONSOLE.printInfo("Will skip waiting for data loading empty response from coordinator");
        }
        CONSOLE.printInfo(String.format("Waiting for the loading of [%s] segments", segments.size()));
        long passiveWaitTimeMs = HiveConf.getLongVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_PASSIVE_WAIT_TIME);
        Set urlsOfUnloadedSegments = segments.stream().map(dataSegment -> {
            try {
                return new URL(String.format("http://%s/druid/coordinator/v1/datasources/%s/segments/%s", coordinatorAddress, dataSegment.getDataSource(), dataSegment.getId().toString()));
            }
            catch (MalformedURLException e) {
                Throwables.propagate(e);
                return null;
            }
        }).collect(Collectors.toSet());
        int numRetries = 0;
        while (numRetries++ < maxTries && !urlsOfUnloadedSegments.isEmpty()) {
            urlsOfUnloadedSegments = ImmutableSet.copyOf(Sets.filter(urlsOfUnloadedSegments, input -> {
                try {
                    String result = DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.GET, (URL)input), new StringFullResponseHandler(Charset.forName("UTF-8"))).getContent();
                    LOG.debug("Checking segment [{}] response is [{}]", input, (Object)result);
                    return Strings.isNullOrEmpty(result);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error(String.format("Error while checking URL [%s]", input), (Throwable)e);
                    return true;
                }
            }));
            try {
                if (urlsOfUnloadedSegments.isEmpty()) continue;
                Thread.sleep(passiveWaitTimeMs);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!urlsOfUnloadedSegments.isEmpty()) {
            CONSOLE.printError(String.format("Wait time exhausted and we have [%s] out of [%s] segments not loaded yet", urlsOfUnloadedSegments.size(), segments.size()));
        }
    }

    @VisibleForTesting
    void deleteSegment(DataSegment segment) throws SegmentLoadingException {
        block6: {
            Path path = DruidStorageHandlerUtils.getPath(segment);
            LOG.info("removing segment {}, located at path {}", (Object)segment.getId().toString(), (Object)path);
            try {
                if (path.getName().endsWith(".zip")) {
                    Path intervalDir;
                    FileSystem fs = path.getFileSystem(this.getConf());
                    if (!fs.exists(path)) {
                        LOG.warn("Segment Path {} does not exist. It appears to have been deleted already.", (Object)path);
                        return;
                    }
                    Path partitionNumDir = path.getParent();
                    if (!fs.delete(partitionNumDir, true)) {
                        throw new SegmentLoadingException("Unable to kill segment, failed to delete dir [%s]", partitionNumDir.toString());
                    }
                    Path versionDir = partitionNumDir.getParent();
                    if (DruidStorageHandler.safeNonRecursiveDelete(fs, versionDir) && DruidStorageHandler.safeNonRecursiveDelete(fs, intervalDir = versionDir.getParent())) {
                        Path dataSourceDir = intervalDir.getParent();
                        DruidStorageHandler.safeNonRecursiveDelete(fs, dataSourceDir);
                    }
                    break block6;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", path);
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    private static boolean safeNonRecursiveDelete(FileSystem fs, Path path) {
        try {
            return fs.delete(path, false);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void preDropTable(Table table) {
    }

    public void rollbackDropTable(Table table) {
    }

    public void commitDropTable(Table table, boolean deleteData) {
        if (DruidKafkaUtils.isKafkaStreamingTable(table)) {
            String overlordAddress = Preconditions.checkNotNull(HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_OVERLORD_DEFAULT_ADDRESS), "Druid Overlord Address is null");
            String dataSourceName = Preconditions.checkNotNull(DruidStorageHandlerUtils.getTableProperty(table, "druid.datasource"), "Druid Datasource name is null");
            this.stopKafkaIngestion(overlordAddress, dataSourceName);
        }
        String dataSourceName = Preconditions.checkNotNull((String)table.getParameters().get("druid.datasource"), "DataSource name is null !");
        if (deleteData && MetaStoreUtils.isExternalTablePurge((Table)table)) {
            LOG.info("Dropping with purge all the data for data source {}", (Object)dataSourceName);
            List<DataSegment> dataSegmentList = DruidStorageHandlerUtils.getDataSegmentList(this.getConnector(), this.getDruidMetadataStorageTablesConfig(), dataSourceName);
            if (dataSegmentList.isEmpty()) {
                LOG.info("Nothing to delete for data source {}", (Object)dataSourceName);
                return;
            }
            for (DataSegment dataSegment : dataSegmentList) {
                try {
                    this.deleteSegment(dataSegment);
                }
                catch (SegmentLoadingException e) {
                    LOG.error(String.format("Error while deleting segment [%s]", dataSegment.getId().toString()), (Throwable)e);
                }
            }
        }
        if (DruidStorageHandlerUtils.disableDataSource(this.getConnector(), this.getDruidMetadataStorageTablesConfig(), dataSourceName)) {
            LOG.info("Successfully dropped druid data source {}", (Object)dataSourceName);
        }
    }

    public void commitInsertTable(Table table, boolean overwrite) throws MetaException {
        LOG.debug("commit insert into table {} overwrite {}", (Object)table.getTableName(), (Object)overwrite);
        try {
            Path segmentDescriptorDir = this.getSegmentDescriptorDir();
            List<DataSegment> segmentsToLoad = this.fetchSegmentsMetadata(segmentDescriptorDir);
            String dataSourceName = (String)table.getParameters().get("druid.datasource");
            if (segmentsToLoad.isEmpty() && overwrite) {
                DruidStorageHandlerUtils.disableDataSource(this.getConnector(), this.getDruidMetadataStorageTablesConfig(), dataSourceName);
            } else if (!segmentsToLoad.isEmpty()) {
                this.checkLoadStatus(this.loadAndCommitDruidSegments(table, overwrite, segmentsToLoad));
            }
        }
        catch (IOException e) {
            throw new MetaException(e.getMessage());
        }
        catch (CallbackFailedException c) {
            LOG.error("Error while committing transaction to druid metadata storage", (Throwable)c);
            throw new MetaException(c.getCause().getMessage());
        }
        finally {
            this.cleanWorkingDir();
        }
    }

    private List<DataSegment> fetchSegmentsMetadata(Path segmentDescriptorDir) throws IOException {
        if (!segmentDescriptorDir.getFileSystem(this.getConf()).exists(segmentDescriptorDir)) {
            LOG.info("Directory {} does not exist, ignore this if it is create statement or inserts of 0 rows, no Druid segments to move, cleaning working directory {}", (Object)segmentDescriptorDir.toString(), (Object)this.getStagingWorkingDir().toString());
            return Collections.emptyList();
        }
        return DruidStorageHandlerUtils.getCreatedSegments(segmentDescriptorDir, this.getConf());
    }

    public void preInsertTable(Table table, boolean overwrite) {
    }

    public void rollbackInsertTable(Table table, boolean overwrite) {
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        jobProperties.put("druid.datasource", tableDesc.getTableName());
        jobProperties.put("druid.segment.version", new DateTime().toString());
        jobProperties.put("druid.job.workingDirectory", this.getStagingWorkingDir().toString());
        jobProperties.put("druid.storage.storageDirectory.intermediate", this.getIntermediateSegmentDir().toString());
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        boolean kerberosEnabled = HiveConf.getBoolVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_KERBEROS_ENABLE);
        if (kerberosEnabled && UserGroupInformation.isSecurityEnabled()) {
            LOG.debug("Setting {} to {} to enable split generation on HS2", (Object)HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION.toString(), (Object)Boolean.FALSE.toString());
            jobConf.set(HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION.toString(), Boolean.FALSE.toString());
        }
        try {
            Utilities.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{DruidRecordWriter.class});
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public LockType getLockType(WriteEntity writeEntity) {
        if (writeEntity.getWriteType().equals((Object)WriteEntity.WriteType.INSERT)) {
            return LockType.SHARED_READ;
        }
        return LockType.SHARED_WRITE;
    }

    public String toString() {
        return "org.apache.hadoop.hive.druid.DruidStorageHandler";
    }

    private String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = Preconditions.checkNotNull(Strings.emptyToNull(HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID)), "Hive query id is null");
        }
        return this.uniqueId;
    }

    private Path getStagingWorkingDir() {
        return new Path(this.getRootWorkingDir(), this.makeStagingName());
    }

    private MetadataStorageTablesConfig getDruidMetadataStorageTablesConfig() {
        if (this.druidMetadataStorageTablesConfig != null) {
            return this.druidMetadataStorageTablesConfig;
        }
        String base = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_BASE);
        this.druidMetadataStorageTablesConfig = MetadataStorageTablesConfig.fromBase(base);
        return this.druidMetadataStorageTablesConfig;
    }

    private SQLMetadataConnector getConnector() {
        return Suppliers.memoize(this::buildConnector).get();
    }

    private static String getPassword(Configuration conf, HiveConf.ConfVars var) {
        try {
            char[] password = conf.getPassword(var.varname);
            return password == null ? null : String.valueOf(password);
        }
        catch (IOException e) {
            LOG.warn("Unable to retrieve password from credential providers. Trying to read it from config..", (Throwable)e);
            return conf.get(var.varname);
        }
    }

    private SQLMetadataConnector buildConnector() {
        if (this.connector != null) {
            return this.connector;
        }
        String dbType = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_TYPE);
        final String username = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_USERNAME);
        final String password = DruidStorageHandler.getPassword(this.getConf(), HiveConf.ConfVars.DRUID_METADATA_DB_PASSWORD);
        final String uri = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_URI);
        LOG.debug("Supplying SQL Connector with DB type {}, URI {}, User {}", new Object[]{dbType, uri, username});
        Supplier<MetadataStorageConnectorConfig> storageConnectorConfigSupplier = Suppliers.ofInstance(new MetadataStorageConnectorConfig(this){

            @Override
            public String getConnectURI() {
                return uri;
            }

            @Override
            public String getUser() {
                return Strings.emptyToNull(username);
            }

            @Override
            public String getPassword() {
                return Strings.emptyToNull(password);
            }
        });
        switch (dbType) {
            case "mysql": {
                this.connector = new MySQLConnector(storageConnectorConfigSupplier, Suppliers.ofInstance(this.getDruidMetadataStorageTablesConfig()), new MySQLConnectorConfig());
                break;
            }
            case "postgresql": {
                this.connector = new PostgreSQLConnector(storageConnectorConfigSupplier, Suppliers.ofInstance(this.getDruidMetadataStorageTablesConfig()), new PostgreSQLConnectorConfig(), new PostgreSQLTablesConfig());
                break;
            }
            case "derby": {
                this.connector = new DerbyConnector(new DerbyMetadataStorage(storageConnectorConfigSupplier.get()), storageConnectorConfigSupplier, Suppliers.ofInstance(this.getDruidMetadataStorageTablesConfig()));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown metadata storage type [%s]", dbType));
            }
        }
        return this.connector;
    }

    @VisibleForTesting
    String makeStagingName() {
        return ".staging-".concat(this.getUniqueId().replace(":", ""));
    }

    private Path getSegmentDescriptorDir() {
        return new Path(this.getStagingWorkingDir(), SEGMENTS_DESCRIPTOR_DIR_NAME);
    }

    private Path getIntermediateSegmentDir() {
        return new Path(this.getStagingWorkingDir(), INTERMEDIATE_SEGMENT_DIR_NAME);
    }

    private void cleanWorkingDir() {
        try {
            FileSystem fileSystem = this.getStagingWorkingDir().getFileSystem(this.getConf());
            fileSystem.delete(this.getStagingWorkingDir(), true);
        }
        catch (IOException e) {
            LOG.error("Got Exception while cleaning working directory", (Throwable)e);
        }
    }

    private String getRootWorkingDir() {
        if (Strings.isNullOrEmpty(this.rootWorkingDir)) {
            this.rootWorkingDir = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_WORKING_DIR);
        }
        return this.rootWorkingDir;
    }

    private static HttpClient makeHttpClient(Lifecycle lifecycle) {
        int numConnection = HiveConf.getIntVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_NUM_HTTP_CONNECTION);
        Period readTimeout = new Period((Object)HiveConf.getVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_HTTP_READ_TIMEOUT));
        LOG.info("Creating Druid HTTP client with {} max parallel connections and {}ms read timeout", (Object)numConnection, (Object)readTimeout.toStandardDuration().getMillis());
        HttpClient httpClient = HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(numConnection).withReadTimeout(new Period((Object)readTimeout).toStandardDuration()).build(), lifecycle);
        boolean kerberosEnabled = HiveConf.getBoolVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_KERBEROS_ENABLE);
        if (kerberosEnabled && UserGroupInformation.isSecurityEnabled()) {
            LOG.info("building Kerberos Http Client");
            return new KerberosHttpClient(httpClient);
        }
        return httpClient;
    }

    public static HttpClient getHttpClient() {
        return HTTP_CLIENT;
    }

    public void preAlterTable(Table table, EnvironmentContext context) throws MetaException {
        String alterOpType;
        String string = alterOpType = context == null ? null : (String)context.getProperties().get("alterTableOpType");
        if (alterOpType != null && !ALLOWED_ALTER_TYPES.contains(alterOpType)) {
            throw new MetaException("ALTER TABLE can not be used for " + alterOpType + " to a non-native table ");
        }
        if (DruidKafkaUtils.isKafkaStreamingTable(table)) {
            this.updateKafkaIngestion(table);
        }
    }

    private int getMaxRetryCount() {
        return HiveConf.getIntVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_MAX_TRIES);
    }

    public StorageHandlerInfo getStorageHandlerInfo(Table table) throws MetaException {
        if (DruidKafkaUtils.isKafkaStreamingTable(table)) {
            KafkaSupervisorReport kafkaSupervisorReport = this.fetchKafkaSupervisorReport(table);
            if (kafkaSupervisorReport == null) {
                return DruidStorageHandlerInfo.UNREACHABLE;
            }
            return new DruidStorageHandlerInfo(kafkaSupervisorReport);
        }
        return null;
    }

    public Map<String, String> getOperatorDescProperties(OperatorDesc operatorDesc, Map<String, String> initialProps) {
        if (operatorDesc instanceof TableScanDesc) {
            TableScanDesc tableScanDesc = (TableScanDesc)operatorDesc;
            ExprNodeGenericFuncDesc filterExpr = tableScanDesc.getFilterExpr();
            String druidQuery = initialProps.get("druid.query.json");
            if (filterExpr != null && druidQuery != null) {
                try {
                    Query query = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, BaseQuery.class);
                    Query queryWithDynamicFilters = DruidStorageHandlerUtils.addDynamicFilters(query, filterExpr, this.conf, false);
                    HashMap<String, String> props = Maps.newHashMap(initialProps);
                    props.put("druid.query.json", DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(queryWithDynamicFilters));
                    return props;
                }
                catch (IOException e) {
                    LOG.error("Exception while deserializing druid query. Explain plan may not have final druid query", (Throwable)e);
                }
            }
        }
        return initialProps;
    }

    static {
        ALLOWED_ALTER_TYPES = ImmutableList.of("ADDPROPS", "DROPPROPS", "ADDCOLS");
        Lifecycle lifecycle = new Lifecycle();
        try {
            lifecycle.start();
        }
        catch (Exception e) {
            LOG.error("Issues with lifecycle start", (Throwable)e);
        }
        HTTP_CLIENT = DruidStorageHandler.makeHttpClient(lifecycle);
        ShutdownHookManager.addShutdownHook(lifecycle::stop);
    }
}

