/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.json.AvroParseSpec;
import org.apache.hadoop.hive.druid.json.AvroStreamInputRowParser;
import org.apache.hadoop.hive.druid.json.InlineSchemaAvroBytesDecoder;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorIOConfig;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorSpec;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorTuningConfig;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DelimitedParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DruidKafkaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DruidKafkaUtils.class);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);

    private DruidKafkaUtils() {
    }

    static KafkaSupervisorSpec createKafkaSupervisorSpec(Table table, String kafkaTopic, String kafkaServers, DataSchema dataSchema, IndexSpec indexSpec) {
        return new KafkaSupervisorSpec(dataSchema, new KafkaSupervisorTuningConfig(DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.maxRowsInMemory"), DruidStorageHandlerUtils.getLongProperty(table, "druid.kafka.ingestion.maxBytesInMemory"), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.maxRowsPerSegment"), DruidStorageHandlerUtils.getLongProperty(table, "druid.kafka.ingestion.maxTotalRows"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.intermediatePersistPeriod"), null, DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.maxPendingPersists"), indexSpec, null, null, DruidStorageHandlerUtils.getBooleanProperty(table, "druid.kafka.ingestion.reportParseExceptions"), DruidStorageHandlerUtils.getLongProperty(table, "druid.kafka.ingestion.handoffConditionTimeout"), DruidStorageHandlerUtils.getBooleanProperty(table, "druid.kafka.ingestion.resetOffsetAutomatically"), TmpFileSegmentWriteOutMediumFactory.instance(), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.workerThreads"), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.chatThreads"), DruidStorageHandlerUtils.getLongProperty(table, "druid.kafka.ingestion.chatRetries"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.httpTimeout"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.shutdownTimeout"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.offsetFetchPeriod"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.intermediateHandoffPeriod"), DruidStorageHandlerUtils.getBooleanProperty(table, "druid.kafka.ingestion.logParseExceptions"), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.maxParseExceptions"), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.maxSavedParseExceptions")), new KafkaSupervisorIOConfig(kafkaTopic, DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.replicas"), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.kafka.ingestion.taskCount"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.taskDuration"), DruidKafkaUtils.getKafkaConsumerProperties(table, kafkaServers), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.startDelay"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.period"), DruidStorageHandlerUtils.getBooleanProperty(table, "druid.kafka.ingestion.useEarliestOffset"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.completionTimeout"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.lateMessageRejectionPeriod"), DruidStorageHandlerUtils.getPeriodProperty(table, "druid.kafka.ingestion.earlyMessageRejectionPeriod"), DruidStorageHandlerUtils.getBooleanProperty(table, "druid.kafka.ingestion.skipOffsetGaps")), new HashMap<String, Object>());
    }

    private static Map<String, String> getKafkaConsumerProperties(Table table, String kafkaServers) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("bootstrap.servers", kafkaServers);
        for (Map.Entry entry : table.getParameters().entrySet()) {
            if (!((String)entry.getKey()).startsWith("druid.kafka.ingestion.consumer.")) continue;
            String propertyName = ((String)entry.getKey()).substring("druid.kafka.ingestion.consumer.".length());
            builder.put(propertyName, (String)entry.getValue());
        }
        return builder.build();
    }

    static void updateKafkaIngestionSpec(String overlordAddress, KafkaSupervisorSpec spec) {
        try {
            String task = DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(spec);
            CONSOLE.printInfo("submitting kafka Spec {}", task);
            LOG.info("submitting kafka Supervisor Spec {}", (Object)task);
            StringFullResponseHolder response = DruidStorageHandlerUtils.getResponseFromCurrentLeader(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.POST, new URL(String.format("http://%s/druid/indexer/v1/supervisor", overlordAddress))).setContent("application/json", DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsBytes(spec)), new StringFullResponseHandler(Charset.forName("UTF-8")));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new IOException(String.format("Unable to update Kafka Ingestion for Druid status [%d] full response [%s]", response.getStatus().getCode(), response.getContent()));
            }
            String msg = String.format("Kafka Supervisor for [%s] Submitted Successfully to druid.", spec.getDataSchema().getDataSource());
            LOG.info(msg);
            CONSOLE.printInfo(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isKafkaStreamingTable(Table table) {
        return DruidStorageHandlerUtils.getTableProperty(table, "kafka.topic") != null;
    }

    static InputRowParser getInputRowParser(Table table, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec) {
        String parseSpecFormat = DruidStorageHandlerUtils.getTableProperty(table, "druid.parseSpec.format");
        if (parseSpecFormat == null || "json".equalsIgnoreCase(parseSpecFormat)) {
            return new StringInputRowParser(new JSONParseSpec(timestampSpec, dimensionsSpec, null, null), "UTF-8");
        }
        if ("csv".equalsIgnoreCase(parseSpecFormat)) {
            return new StringInputRowParser(new CSVParseSpec(timestampSpec, dimensionsSpec, DruidStorageHandlerUtils.getTableProperty(table, "druid.parseSpec.listDelimiter"), DruidStorageHandlerUtils.getListProperty(table, "druid.parseSpec.columns"), DruidStorageHandlerUtils.getBooleanProperty(table, "druid.parseSpec.hasHeaderRows", false), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.parseSpec.skipHeaderRows", 0)), "UTF-8");
        }
        if ("delimited".equalsIgnoreCase(parseSpecFormat)) {
            return new StringInputRowParser(new DelimitedParseSpec(timestampSpec, dimensionsSpec, DruidStorageHandlerUtils.getTableProperty(table, "druid.parseSpec.delimiter"), DruidStorageHandlerUtils.getTableProperty(table, "druid.parseSpec.listDelimiter"), DruidStorageHandlerUtils.getListProperty(table, "druid.parseSpec.columns"), DruidStorageHandlerUtils.getBooleanProperty(table, "druid.parseSpec.hasHeaderRows", false), DruidStorageHandlerUtils.getIntegerProperty(table, "druid.parseSpec.skipHeaderRows", 0)), "UTF-8");
        }
        if ("avro".equalsIgnoreCase(parseSpecFormat)) {
            try {
                String avroSchemaLiteral = DruidStorageHandlerUtils.getTableProperty(table, "avro.schema.literal");
                Preconditions.checkNotNull(avroSchemaLiteral, "Please specify avro schema literal when using avro parser");
                Map<String, Object> avroSchema = DruidStorageHandlerUtils.JSON_MAPPER.readValue(avroSchemaLiteral, new TypeReference<Map<String, Object>>(){});
                return new AvroStreamInputRowParser(new AvroParseSpec(timestampSpec, dimensionsSpec, null), new InlineSchemaAvroBytesDecoder(avroSchema));
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception while creating avro schema", e);
            }
        }
        throw new IllegalArgumentException("Invalid parse spec format [" + parseSpecFormat + "]. Supported types are : json, csv, tsv, avro");
    }
}

