/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class HadoopFsWrapper {
    private static final Logger log = new Logger(HadoopFsWrapper.class);

    private HadoopFsWrapper() {
    }

    public static boolean rename(FileSystem fs, Path from, Path to) {
        try {
            Method renameMethod = HadoopFsWrapper.findRenameMethodRecursively(fs.getClass());
            renameMethod.invoke((Object)fs, from, to, new Options.Rename[]{Options.Rename.NONE});
            return true;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof FileAlreadyExistsException) {
                log.info(ex, "Destination exists while renaming [%s] to [%s]", from, to);
                return false;
            }
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            for (Method method : fs.getClass().getDeclaredMethods()) {
                log.error(method.toGenericString(), new Object[0]);
            }
            throw new RuntimeException(ex);
        }
    }

    private static Method findRenameMethodRecursively(Class<?> clazz) throws NoSuchMethodException {
        try {
            Method renameMethod = clazz.getDeclaredMethod("rename", Path.class, Path.class, Options.Rename[].class);
            renameMethod.setAccessible(true);
            return renameMethod;
        }
        catch (NoSuchMethodException ex) {
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz == null) {
                throw ex;
            }
            return HadoopFsWrapper.findRenameMethodRecursively(superClazz);
        }
    }
}

