/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloIndexLexicoder;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableInputFormat;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableOutputFormat;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloStorageHandler
extends DefaultStorageHandler
implements HiveMetaHook,
HiveStoragePredicateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AccumuloStorageHandler.class);
    private static final String DEFAULT_PREFIX = "default";
    protected AccumuloPredicateHandler predicateHandler = AccumuloPredicateHandler.getInstance();
    protected AccumuloConnectionParameters connectionParams;
    protected HiveAccumuloHelper helper = new HiveAccumuloHelper();

    public void configureTableJobProperties(TableDesc desc, Map<String, String> jobProps) {
        this.configureInputJobProperties(desc, jobProps);
        this.configureOutputJobProperties(desc, jobProps);
    }

    protected String getTableName(Table table) throws MetaException {
        String tableName = (String)table.getParameters().get("accumulo.table.name");
        if (null != tableName) {
            return tableName;
        }
        tableName = (String)table.getSd().getSerdeInfo().getParameters().get("accumulo.table.name");
        if (null != tableName) {
            return tableName;
        }
        if (DEFAULT_PREFIX.equals(table.getDbName())) {
            return table.getTableName();
        }
        return TableName.getDbTable((String)table.getDbName(), (String)table.getTableName());
    }

    protected String getIndexTableName(Table table) {
        String idxTableName = (String)table.getParameters().get("accumulo.indextable.name");
        if (null != idxTableName) {
            return idxTableName;
        }
        idxTableName = (String)table.getSd().getSerdeInfo().getParameters().get("accumulo.indextable.name");
        return idxTableName;
    }

    protected String getTableName(TableDesc tableDesc) {
        Properties props = tableDesc.getProperties();
        String tableName = props.getProperty("accumulo.table.name");
        if (null != tableName) {
            return tableName;
        }
        tableName = props.getProperty("name");
        if (tableName.startsWith("default.")) {
            return tableName.substring(DEFAULT_PREFIX.length() + 1);
        }
        return tableName;
    }

    protected String getIndexTableName(TableDesc tableDesc) {
        Properties props = tableDesc.getProperties();
        String tableName = props.getProperty("accumulo.indextable.name");
        return tableName;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.connectionParams = new AccumuloConnectionParameters(conf);
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return AccumuloSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        String authValue;
        String storageType;
        Properties props = tableDesc.getProperties();
        jobProperties.put("accumulo.columns.mapping", props.getProperty("accumulo.columns.mapping"));
        String tableName = props.getProperty("accumulo.table.name");
        if (null == tableName) {
            tableName = this.getTableName(tableDesc);
        }
        jobProperties.put("accumulo.table.name", tableName);
        String useIterators = props.getProperty("accumulo.iterator.pushdown");
        if (useIterators != null) {
            if (!"true".equalsIgnoreCase(useIterators) && !"false".equalsIgnoreCase(useIterators)) {
                throw new IllegalArgumentException("Expected value of true or false for accumulo.iterator.pushdown");
            }
            jobProperties.put("accumulo.iterator.pushdown", useIterators);
        }
        if (null != (storageType = props.getProperty("accumulo.default.storage"))) {
            jobProperties.put("accumulo.default.storage", storageType);
        }
        if (null != (authValue = props.getProperty("accumulo.authorizations"))) {
            jobProperties.put("accumulo.authorizations", authValue);
        }
        LOG.info("Computed input job properties of " + String.valueOf(jobProperties));
        Configuration conf = this.getConf();
        this.helper.loadDependentJars(conf);
        if (this.connectionParams.useSasl()) {
            try {
                Connector conn = this.connectionParams.getConnector();
                Token<? extends TokenIdentifier> accumuloToken = this.helper.setConnectorInfoForInputAndOutput(this.connectionParams, conn, conf);
                if (conf instanceof JobConf) {
                    LOG.debug("Adding Hadoop Token for Accumulo to Job's Credentials: " + String.valueOf(accumuloToken));
                    JobConf jobConf = (JobConf)conf;
                    jobConf.getCredentials().addToken(accumuloToken.getService(), accumuloToken);
                    LOG.info("All job tokens: " + String.valueOf(jobConf.getCredentials().getAllTokens()));
                } else {
                    LOG.info("Don't have a JobConf, so we cannot persist Tokens. Have to do it later.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to obtain DelegationToken for " + this.connectionParams.getAccumuloUserName(), e);
            }
        }
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties props = tableDesc.getProperties();
        String colMap = props.getProperty("accumulo.columns.mapping");
        jobProperties.put("accumulo.columns.mapping", colMap);
        String tableName = props.getProperty("accumulo.table.name");
        if (null == tableName) {
            tableName = this.getTableName(tableDesc);
        }
        jobProperties.put("accumulo.table.name", tableName);
        String indexTable = props.getProperty("accumulo.indextable.name");
        if (null == indexTable) {
            indexTable = this.getIndexTableName(tableDesc);
        }
        if (null != indexTable) {
            jobProperties.put("accumulo.indextable.name", indexTable);
            String indexColumns = props.getProperty("accumulo.indexed.columns");
            jobProperties.put("accumulo.indexed.columns", this.getIndexedColFamQuals(tableDesc, indexColumns, colMap));
        }
        if (props.containsKey("accumulo.default.storage")) {
            jobProperties.put("accumulo.default.storage", props.getProperty("accumulo.default.storage"));
        }
        if (props.containsKey("accumulo.visibility.label")) {
            jobProperties.put("accumulo.visibility.label", props.getProperty("accumulo.visibility.label"));
        }
    }

    private String getIndexedColFamQuals(TableDesc tableDesc, String indexColumns, String colMap) {
        StringBuilder sb = new StringBuilder();
        String cols = indexColumns;
        String hiveColString = tableDesc.getProperties().getProperty("columns");
        if (cols == null || cols.isEmpty() || "*".equals(indexColumns)) {
            cols = hiveColString.substring(hiveColString.indexOf(44) + 1);
        }
        String[] hiveTypes = tableDesc.getProperties().getProperty("columns.types").split(":");
        String[] accCols = colMap.split(",");
        String[] hiveCols = hiveColString.split(",");
        HashSet<String> indexSet = new HashSet<String>();
        for (String idx : cols.split(",")) {
            indexSet.add(idx.trim());
        }
        for (int i = 0; i < hiveCols.length; ++i) {
            if (!indexSet.contains(hiveCols[i].trim())) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(accCols[i].trim() + ":" + AccumuloIndexLexicoder.getRawType(hiveTypes[i]));
        }
        return sb.toString();
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveAccumuloTableInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveAccumuloTableOutputFormat.class;
    }

    public void preCreateTable(Table table) throws MetaException {
        if (table.getSd().getLocation() != null) {
            throw new MetaException("Location can't be specified for Accumulo");
        }
        Map serdeParams = table.getSd().getSerdeInfo().getParameters();
        String columnMapping = (String)serdeParams.get("accumulo.columns.mapping");
        if (columnMapping == null) {
            throw new MetaException("accumulo.columns.mapping missing from SERDEPROPERTIES");
        }
        try {
            String idxTable;
            String tblName = this.getTableName(table);
            Connector connector = this.connectionParams.getConnector();
            TableOperations tableOpts = connector.tableOperations();
            if (!tableOpts.exists(tblName)) {
                tableOpts.create(tblName);
            }
            if ((idxTable = this.getIndexTableName(table)) != null && !idxTable.isEmpty() && !tableOpts.exists(idxTable)) {
                tableOpts.create(idxTable);
            }
        }
        catch (AccumuloSecurityException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
        catch (TableExistsException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
        catch (AccumuloException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
    }

    protected boolean isPurge(Table table) {
        return !MetaStoreUtils.isExternalTable((Table)table) || MetaStoreUtils.isExternalTablePurge((Table)table);
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        this.commitDropTable(table, true);
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
        String tblName = this.getTableName(table);
        if (this.isPurge(table)) {
            try {
                TableOperations tblOpts;
                if (deleteData && (tblOpts = this.connectionParams.getConnector().tableOperations()).exists(tblName)) {
                    tblOpts.delete(tblName);
                }
            }
            catch (AccumuloException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
            catch (AccumuloSecurityException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
            catch (TableNotFoundException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf conf, Deserializer deserializer, ExprNodeDesc desc) {
        if (!(deserializer instanceof AccumuloSerDe)) {
            throw new RuntimeException("Expected an AccumuloSerDe but got " + deserializer.getClass().getName());
        }
        AccumuloSerDe serDe = (AccumuloSerDe)deserializer;
        if (serDe.getIteratorPushdown()) {
            return this.predicateHandler.decompose((Configuration)conf, desc);
        }
        LOG.info("Set to ignore Accumulo iterator pushdown, skipping predicate handler.");
        return null;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        this.helper.loadDependentJars((Configuration)jobConf);
        Properties tblProperties = tableDesc.getProperties();
        AccumuloSerDeParameters serDeParams = null;
        try {
            serDeParams = new AccumuloSerDeParameters((Configuration)jobConf, tblProperties, AccumuloSerDe.class.getName());
        }
        catch (SerDeException e) {
            LOG.error("Could not instantiate AccumuloSerDeParameters", (Throwable)e);
            return;
        }
        try {
            serDeParams.getRowIdFactory().addDependencyJars((Configuration)jobConf);
        }
        catch (IOException e) {
            LOG.error("Could not add necessary dependencies for " + String.valueOf(serDeParams.getRowIdFactory().getClass()), (Throwable)e);
        }
        if (this.connectionParams.useSasl()) {
            try {
                Connector conn = this.connectionParams.getConnector();
                Token<? extends TokenIdentifier> accumuloToken = this.helper.setConnectorInfoForInputAndOutput(this.connectionParams, conn, (Configuration)jobConf);
                LOG.debug("Adding Hadoop Token for Accumulo to Job's Credentials");
                this.helper.mergeTokenIntoJobConf(jobConf, accumuloToken);
                LOG.debug("All job tokens: " + String.valueOf(jobConf.getCredentials().getAllTokens()));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to obtain DelegationToken for " + this.connectionParams.getAccumuloUserName(), e);
            }
        }
    }
}

