/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KeepTransactionAliveResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.transactions.TxnManager;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class KeepTransactionAliveRequest
extends KuduRpc<KeepTransactionAliveResponse> {
    private static final List<Integer> featureFlags = ImmutableList.of();
    private final long txnId;

    KeepTransactionAliveRequest(KuduTable masterTable, Timer timer, long timeoutMillis, long txnId) {
        super(masterTable, timer, timeoutMillis);
        Preconditions.checkArgument(txnId > -1L);
        this.txnId = txnId;
    }

    @Override
    Message createRequestPB() {
        TxnManager.KeepTransactionAliveRequestPB.Builder b = TxnManager.KeepTransactionAliveRequestPB.newBuilder();
        b.setTxnId(this.txnId);
        return b.build();
    }

    @Override
    String serviceName() {
        return "kudu.transactions.TxnManagerService";
    }

    @Override
    String method() {
        return "KeepTransactionAlive";
    }

    @Override
    Pair<KeepTransactionAliveResponse, Object> deserialize(CallResponse callResponse, String serverUUID) throws KuduException {
        TxnManager.KeepTransactionAliveResponsePB.Builder b = TxnManager.KeepTransactionAliveResponsePB.newBuilder();
        KeepTransactionAliveRequest.readProtobuf(callResponse.getPBMessage(), b);
        KeepTransactionAliveResponse response = new KeepTransactionAliveResponse(this.timeoutTracker.getElapsedMillis(), serverUUID);
        return new Pair<KeepTransactionAliveResponse, Object>(response, b.hasError() ? b.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return featureFlags;
    }
}

