/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.acl;

import java.util.Objects;
import org.apache.kafkaesque.common.acl.AccessControlEntryFilter;
import org.apache.kafkaesque.common.acl.AclBinding;
import org.apache.kafkaesque.common.annotation.InterfaceStability;
import org.apache.kafkaesque.common.resource.PatternType;
import org.apache.kafkaesque.common.resource.ResourceFilter;
import org.apache.kafkaesque.common.resource.ResourcePatternFilter;

@InterfaceStability.Evolving
public class AclBindingFilter {
    private final ResourcePatternFilter patternFilter;
    private final AccessControlEntryFilter entryFilter;
    public static final AclBindingFilter ANY = new AclBindingFilter(ResourcePatternFilter.ANY, AccessControlEntryFilter.ANY);

    public AclBindingFilter(ResourcePatternFilter patternFilter, AccessControlEntryFilter entryFilter) {
        this.patternFilter = Objects.requireNonNull(patternFilter, "patternFilter");
        this.entryFilter = Objects.requireNonNull(entryFilter, "entryFilter");
    }

    @Deprecated
    public AclBindingFilter(ResourceFilter resourceFilter, AccessControlEntryFilter entryFilter) {
        this(new ResourcePatternFilter(resourceFilter.resourceType(), resourceFilter.name(), PatternType.LITERAL), entryFilter);
    }

    public boolean isUnknown() {
        return this.patternFilter.isUnknown() || this.entryFilter.isUnknown();
    }

    public ResourcePatternFilter patternFilter() {
        return this.patternFilter;
    }

    public final AccessControlEntryFilter entryFilter() {
        return this.entryFilter;
    }

    public String toString() {
        return "(patternFilter=" + this.patternFilter + ", entryFilter=" + this.entryFilter + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AclBindingFilter that = (AclBindingFilter)o;
        return Objects.equals(this.patternFilter, that.patternFilter) && Objects.equals(this.entryFilter, that.entryFilter);
    }

    public boolean matchesAtMostOne() {
        return this.patternFilter.matchesAtMostOne() && this.entryFilter.matchesAtMostOne();
    }

    public String findIndefiniteField() {
        String indefinite = this.patternFilter.findIndefiniteField();
        if (indefinite != null) {
            return indefinite;
        }
        return this.entryFilter.findIndefiniteField();
    }

    public boolean matches(AclBinding binding) {
        return this.patternFilter.matches(binding.pattern()) && this.entryFilter.matches(binding.entry());
    }

    public int hashCode() {
        return Objects.hash(this.patternFilter, this.entryFilter);
    }
}

