/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivityNodeInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAllocationInfo {
    protected String nodeId;
    protected String queueName;
    protected String appPriority;
    protected String allocatedContainerId;
    protected String allocationState;
    protected String diagnostic;
    protected String timeStamp;
    protected List<ActivityNodeInfo> allocationAttempt;
    private static final Log LOG = LogFactory.getLog(AppAllocationInfo.class);

    AppAllocationInfo() {
    }

    AppAllocationInfo(AppAllocation allocation) {
        this.allocationAttempt = new ArrayList<ActivityNodeInfo>();
        this.nodeId = allocation.getNodeId();
        this.queueName = allocation.getQueueName();
        this.appPriority = allocation.getPriority();
        this.allocatedContainerId = allocation.getContainerId();
        this.allocationState = allocation.getAppState().name();
        this.diagnostic = allocation.getDiagnostic();
        Date date = new Date();
        date.setTime(allocation.getTime());
        this.timeStamp = date.toString();
        for (ActivityNode attempt : allocation.getAllocationAttempts()) {
            ActivityNodeInfo containerInfo = new ActivityNodeInfo(attempt);
            this.allocationAttempt.add(containerInfo);
        }
    }
}

