/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.DescriptionUtils;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class MatchingRule
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    protected LdapComparator<? super Object> ldapComparator;
    protected Normalizer normalizer;
    protected LdapSyntax ldapSyntax;
    protected String ldapSyntaxOid;

    public MatchingRule(String oid) {
        super(SchemaObjectType.MATCHING_RULE, oid);
    }

    public LdapSyntax getSyntax() {
        return this.ldapSyntax;
    }

    public String getSyntaxOid() {
        return this.ldapSyntaxOid;
    }

    public LdapComparator<? super Object> getLdapComparator() {
        return this.ldapComparator;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public MatchingRule copy() {
        MutableMatchingRule copy = new MutableMatchingRule(this.oid);
        copy.copy(this);
        copy.ldapComparator = null;
        copy.ldapSyntax = null;
        copy.normalizer = null;
        copy.ldapSyntaxOid = this.ldapSyntaxOid;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MatchingRule)) {
            return false;
        }
        MatchingRule that = (MatchingRule)o;
        if (this.ldapComparator != null ? !this.ldapComparator.equals(that.ldapComparator) : that.ldapComparator != null) {
            return false;
        }
        if (this.normalizer != null ? !this.normalizer.equals(that.normalizer) : that.normalizer != null) {
            return false;
        }
        if (!this.compareOid(this.ldapSyntaxOid, that.ldapSyntaxOid)) {
            return false;
        }
        return !(this.ldapSyntax != null ? !this.ldapSyntax.equals(that.ldapSyntax) : that.ldapSyntax != null);
    }
}

