/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.brotli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.brotli.BrotliCompressor;
import org.apache.hadoop.hbase.io.compress.brotli.BrotliDecompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BrotliCodec
implements Configurable,
CompressionCodec {
    public static final String BROTLI_LEVEL_KEY = "hbase.io.compress.brotli.level";
    public static final int BROTLI_LEVEL_DEFAULT = 6;
    public static final String BROTLI_WINDOW_KEY = "hbase.io.compress.brotli.window";
    public static final int BROTLI_WINDOW_DEFAULT = -1;
    public static final String BROTLI_BUFFERSIZE_KEY = "hbase.io.compress.brotli.buffersize";
    public static final int BROTLI_BUFFERSIZE_DEFAULT = 262144;
    private Configuration conf = new Configuration();
    private int bufferSize = BrotliCodec.getBufferSize(this.conf);
    private int level = BrotliCodec.getLevel(this.conf);
    private int window = BrotliCodec.getWindow(this.conf);

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = BrotliCodec.getBufferSize(conf);
        this.level = BrotliCodec.getLevel(conf);
        this.window = BrotliCodec.getWindow(conf);
    }

    public Compressor createCompressor() {
        return new BrotliCompressor(this.level, this.window, this.bufferSize);
    }

    public Decompressor createDecompressor() {
        return new BrotliDecompressor(this.bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, CompressionUtil.compressionOverhead((int)this.bufferSize));
    }

    public Class<? extends Compressor> getCompressorType() {
        return BrotliCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return BrotliDecompressor.class;
    }

    public String getDefaultExtension() {
        return ".br";
    }

    static int getLevel(Configuration conf) {
        return conf.getInt(BROTLI_LEVEL_KEY, 6);
    }

    static int getWindow(Configuration conf) {
        return conf.getInt(BROTLI_WINDOW_KEY, -1);
    }

    static int getBufferSize(Configuration conf) {
        return conf.getInt(BROTLI_BUFFERSIZE_KEY, 262144);
    }
}

