/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestAclConfigFlag {
    private static final Path PATH = new Path("/path");
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @After
    public void shutdown() throws Exception {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testModifyAclEntries() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.modifyAclEntries(PATH, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE)}));
    }

    @Test
    public void testRemoveAclEntries() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.removeAclEntries(PATH, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE)}));
    }

    @Test
    public void testRemoveDefaultAcl() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.removeAclEntries(PATH, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE)}));
    }

    @Test
    public void testRemoveAcl() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.removeAcl(PATH);
    }

    @Test
    public void testSetAcl() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.setAcl(PATH, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE)}));
    }

    @Test
    public void testGetAclStatus() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.getAclStatus(PATH);
    }

    @Test
    public void testEditLog() throws Exception {
        this.initCluster(true, true);
        this.fs.mkdirs(PATH);
        this.fs.setAcl(PATH, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE)}));
        this.restart(false, false);
    }

    @Test
    public void testFsImage() throws Exception {
        this.initCluster(true, true);
        this.fs.mkdirs(PATH);
        this.fs.setAcl(PATH, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE)}));
        this.restart(true, true);
        this.restart(false, false);
    }

    private void expectException() {
        this.exception.expect(AclException.class);
        this.exception.expectMessage("dfs.namenode.acls.enabled");
    }

    private void initCluster(boolean format, boolean aclsEnabled) throws Exception {
        Configuration conf = new Configuration();
        if (aclsEnabled) {
            conf.setBoolean("dfs.namenode.acls.enabled", true);
        }
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    private void restart(boolean checkpoint, boolean aclsEnabled) throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        this.shutdown();
        this.initCluster(false, aclsEnabled);
    }
}

