/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestHTableNoncedRetry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHTableNoncedRetry.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static final byte[] QUALIFIER2 = Bytes.toBytes((String)"cq2");
    private static final byte[] QUALIFIER3 = Bytes.toBytes((String)"cq3");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static Connection CONN;
    @Rule
    public TestName testName = new TestName();
    private byte[] row;
    private Table table;
    private static final AtomicInteger CALLED;
    private static final int SLEEP_TIME = 2000;
    private static final int RPC_TIMEOUT = 1500;
    private static int miniBatchOperationCount;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(SleepOnceCP.class.getName()).build());
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        CONN = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.row = Bytes.toBytes((String)this.testName.getMethodName().replaceAll("[^0-9A-Za-z]", "_"));
        CALLED.set(0);
        this.table = CONN.getTable(TABLE_NAME);
        this.table.setRpcTimeout(1500);
    }

    @After
    public void tearDown() throws Exception {
        this.table.close();
    }

    @Test
    public void testAppend() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        Result result = this.table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
    }

    @Test
    public void testAppendWhenReturnResultsEqualsFalse() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        Result result = this.table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE).setReturnResults(false));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testIncrement() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        long result = this.table.incrementColumnValue(this.row, FAMILY, QUALIFIER, 1L);
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testIncrementWhenReturnResultsEqualsFalse() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        Result result = this.table.increment(new Increment(this.row).addColumn(FAMILY, QUALIFIER, 1L).setReturnResults(false));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testIncrementInRowMutations() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        Result result = this.table.mutateRow(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(FAMILY, QUALIFIER, 1L)).add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER2)));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testAppendInRowMutations() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        Result result = this.table.mutateRow(new RowMutations(this.row).add((Mutation)new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER2)));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
    }

    @Test
    public void testIncrementAndAppendInRowMutations() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        Result result = this.table.mutateRow(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(FAMILY, QUALIFIER, 1L)).add((Mutation)new Append(this.row).addColumn(FAMILY, QUALIFIER2, VALUE)));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, QUALIFIER)));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER2));
    }

    @Test
    public void testIncrementInCheckAndMutate() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        CheckAndMutateResult result = this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER2).build(new Increment(this.row).addColumn(FAMILY, QUALIFIER, 1L)));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testAppendInCheckAndMutate() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        CheckAndMutateResult result = this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER2).build(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE)));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getResult().getValue(FAMILY, QUALIFIER));
    }

    @Test
    public void testIncrementInRowMutationsInCheckAndMutate() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        CheckAndMutateResult result = this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER3).build(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(FAMILY, QUALIFIER, 1L)).add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER2))));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testAppendInRowMutationsInCheckAndMutate() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        CheckAndMutateResult result = this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER3).build(new RowMutations(this.row).add((Mutation)new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER2))));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getResult().getValue(FAMILY, QUALIFIER));
    }

    @Test
    public void testIncrementAndAppendInRowMutationsInCheckAndMutate() throws IOException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 1;
        CheckAndMutateResult result = this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(FAMILY, QUALIFIER3).build(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(FAMILY, QUALIFIER, 1L)).add((Mutation)new Append(this.row).addColumn(FAMILY, QUALIFIER2, VALUE))));
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, QUALIFIER)));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getResult().getValue(FAMILY, QUALIFIER2));
    }

    @Test
    public void testBatch() throws IOException, InterruptedException {
        byte[] row2 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "2"));
        byte[] row3 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "3"));
        byte[] row4 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "4"));
        byte[] row5 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "5"));
        byte[] row6 = Bytes.toBytes((String)(Bytes.toString((byte[])this.row) + "6"));
        Assert.assertEquals((long)0L, (long)CALLED.get());
        miniBatchOperationCount = 6;
        Object[] results = new Object[6];
        this.table.batch(Arrays.asList(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE), new Increment(row2).addColumn(FAMILY, QUALIFIER, 1L), new RowMutations(row3).add((Mutation)new Increment(row3).addColumn(FAMILY, QUALIFIER, 1L)).add((Mutation)new Append(row3).addColumn(FAMILY, QUALIFIER2, VALUE)), CheckAndMutate.newBuilder((byte[])row4).ifNotExists(FAMILY, QUALIFIER2).build(new Increment(row4).addColumn(FAMILY, QUALIFIER, 1L)), CheckAndMutate.newBuilder((byte[])row5).ifNotExists(FAMILY, QUALIFIER2).build(new Append(row5).addColumn(FAMILY, QUALIFIER, VALUE)), CheckAndMutate.newBuilder((byte[])row6).ifNotExists(FAMILY, QUALIFIER3).build(new RowMutations(row6).add((Mutation)new Increment(row6).addColumn(FAMILY, QUALIFIER, 1L)).add((Mutation)new Append(row6).addColumn(FAMILY, QUALIFIER2, VALUE)))), results);
        Assert.assertEquals((long)12L, (long)CALLED.get());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])((Result)results[0]).getValue(FAMILY, QUALIFIER));
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])((Result)results[1]).getValue(FAMILY, QUALIFIER)));
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])((Result)results[2]).getValue(FAMILY, QUALIFIER)));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])((Result)results[2]).getValue(FAMILY, QUALIFIER2));
        CheckAndMutateResult result = (CheckAndMutateResult)results[3];
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, QUALIFIER)));
        result = (CheckAndMutateResult)results[4];
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getResult().getValue(FAMILY, QUALIFIER));
        result = (CheckAndMutateResult)results[5];
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, QUALIFIER)));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getResult().getValue(FAMILY, QUALIFIER2));
    }

    static {
        CALLED = new AtomicInteger();
    }

    public static final class SleepOnceCP
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) {
            if (CALLED.getAndIncrement() == miniBatchOperationCount - 1) {
                Threads.sleepWithoutInterrupt((long)2000L);
            }
        }
    }
}

