/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractTestScanCursor {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static TableName TABLE_NAME = TableName.valueOf((String)"TestScanCursor");
    protected static int NUM_ROWS = 5;
    protected static byte[] ROW = Bytes.toBytes((String)"testRow");
    protected static byte[][] ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
    protected static int NUM_FAMILIES = 2;
    protected static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    protected static byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
    protected static int NUM_QUALIFIERS = 2;
    protected static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    protected static byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
    protected static int VALUE_SIZE = 10;
    protected static byte[] VALUE = Bytes.createMaxByteArray((int)VALUE_SIZE);
    protected static final int TIMEOUT = 4000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.timeout.period", 4000);
        conf.setInt("hbase.rpc.timeout", 4000);
        conf.setLong(StoreScanner.HBASE_CELLS_SCANNED_PER_HEARTBEAT_CHECK, 1L);
        TEST_UTIL.startMiniCluster(1);
        AbstractTestScanCursor.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
    }

    private static void createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        TEST_UTIL.createTable(name, families).put(AbstractTestScanCursor.createPuts(rows, families, qualifiers, cellValue));
    }

    private static List<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add((Cell)kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected Scan createScanWithSparseFilter() {
        return new Scan().setMaxResultSize(Long.MAX_VALUE).setCaching(Integer.MAX_VALUE).setNeedCursorResult(true).setAllowPartialResults(true).setFilter((Filter)new SparseFilter(false));
    }

    protected Scan createReversedScanWithSparseFilter() {
        return new Scan().setMaxResultSize(Long.MAX_VALUE).setCaching(Integer.MAX_VALUE).setReversed(true).setNeedCursorResult(true).setAllowPartialResults(true).setFilter((Filter)new SparseFilter(true));
    }

    protected Scan createScanWithSizeLimit() {
        return new Scan().setMaxResultSize(1L).setCaching(Integer.MAX_VALUE).setNeedCursorResult(true);
    }

    public static final class SparseFilter
    extends FilterBase {
        private final boolean reversed;

        public SparseFilter(boolean reversed) {
            this.reversed = reversed;
        }

        public Filter.ReturnCode filterCell(Cell c) throws IOException {
            Threads.sleep((long)2100L);
            return Bytes.equals((byte[])CellUtil.cloneRow((Cell)c), (byte[])ROWS[this.reversed ? 0 : NUM_ROWS - 1]) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }

        public byte[] toByteArray() throws IOException {
            byte[] byArray;
            if (this.reversed) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            return byArray;
        }

        public static Filter parseFrom(byte[] pbBytes) {
            return new SparseFilter(pbBytes[0] != 0);
        }
    }
}

