/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.apache.hadoop.hbase.io.crypto.tls.FileKeyStoreLoader;

abstract class StandardTypeFileKeyStoreLoader
extends FileKeyStoreLoader {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected final SupportedStandardKeyFormat format;

    StandardTypeFileKeyStoreLoader(String keyStorePath, String trustStorePath, char[] keyStorePassword, char[] trustStorePassword, SupportedStandardKeyFormat format) {
        super(keyStorePath, trustStorePath, keyStorePassword, trustStorePassword);
        this.format = format;
    }

    @Override
    public KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(new File(this.keyStorePath).toPath(), new OpenOption[0]);){
            KeyStore ks = this.keyStoreInstance();
            ks.load(inputStream, StandardTypeFileKeyStoreLoader.passwordStringToCharArray(this.keyStorePassword));
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    @Override
    public KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(new File(this.trustStorePath).toPath(), new OpenOption[0]);){
            KeyStore ts = this.keyStoreInstance();
            ts.load(inputStream, StandardTypeFileKeyStoreLoader.passwordStringToCharArray(this.trustStorePassword));
            KeyStore keyStore = ts;
            return keyStore;
        }
    }

    private KeyStore keyStoreInstance() throws KeyStoreException {
        return KeyStore.getInstance(this.format.name());
    }

    private static char[] passwordStringToCharArray(char[] password) {
        return password == null ? EMPTY_CHAR_ARRAY : password;
    }

    protected static enum SupportedStandardKeyFormat {
        JKS,
        PKCS12,
        BCFKS;

    }
}

