/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.regionserver.DateTieredStoreEngine;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileManager;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.compactions.CustomDateTieredCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CustomTieredCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionPolicy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CustomTieredStoreEngine
extends DateTieredStoreEngine {
    @Override
    protected void createComponents(Configuration conf, HStore store, CellComparator kvComparator) throws IOException {
        CompoundConfiguration config = new CompoundConfiguration();
        config.add(conf);
        config.add(store.conf);
        config.set(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, CustomDateTieredCompactionPolicy.class.getName());
        this.createCompactionPolicy((Configuration)config, store);
        this.storeFileManager = new DefaultStoreFileManager(kvComparator, StoreFileComparators.SEQ_ID_MAX_TIMESTAMP, (Configuration)config, ((DateTieredCompactionPolicy)this.compactionPolicy).getConf());
        this.storeFlusher = new DefaultStoreFlusher((Configuration)config, store);
        this.compactor = new CustomTieredCompactor((Configuration)config, store);
    }
}

