/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestHalfStoreFileReader {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHalfStoreFileReader.class);
    private static HBaseTestingUtility TEST_UTIL;
    static final int SIZE = 1000;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testHalfScanAndReseek() throws IOException, InterruptedException {
        Configuration conf = TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String root_dir = TEST_UTIL.getDataTestDir().toString();
        Path parentPath = new Path(new Path(root_dir, "parent"), "CF");
        fs.mkdirs(parentPath);
        String tableName = Paths.get(root_dir, new String[0]).getFileName().toString();
        RegionInfo splitAHri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).build();
        Thread.currentThread();
        Thread.sleep(1000L);
        RegionInfo splitBHri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).build();
        Path splitAPath = new Path(new Path(root_dir, splitAHri.getRegionNameAsString()), "CF");
        Path splitBPath = new Path(new Path(root_dir, splitBHri.getRegionNameAsString()), "CF");
        Path filePath = StoreFileWriter.getUniqueFile((FileSystem)fs, (Path)parentPath);
        CacheConfig cacheConf = new CacheConfig(conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(1024).build();
        HFile.Writer w = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, filePath).withFileContext(meta).create();
        List<KeyValue> items = this.genSomeKeys();
        for (KeyValue kv : items) {
            w.append((Cell)kv);
        }
        w.close();
        HFile.Reader r = HFile.createReader((FileSystem)fs, (Path)filePath, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        Cell midKV = (Cell)r.midKey().get();
        byte[] midkey = CellUtil.cloneRow((Cell)midKV);
        Path splitFileA = new Path(splitAPath, filePath.getName() + ".parent");
        Path splitFileB = new Path(splitBPath, filePath.getName() + ".parent");
        HRegionFileSystem splitAregionFS = HRegionFileSystem.create((Configuration)conf, (FileSystem)fs, (Path)new Path(root_dir), (RegionInfo)splitAHri);
        StoreContext splitAStoreContext = StoreContext.getBuilder().withColumnFamilyDescriptor(ColumnFamilyDescriptorBuilder.of((String)"CF")).withFamilyStoreDirectoryPath(splitAPath).withRegionFileSystem(splitAregionFS).build();
        StoreFileTracker splitAsft = StoreFileTrackerFactory.create((Configuration)conf, (boolean)false, (StoreContext)splitAStoreContext);
        Reference bottom = new Reference(midkey, Reference.Range.bottom);
        splitAsft.createReference(bottom, splitFileA);
        this.doTestOfScanAndReseek(splitFileA, fs, bottom, cacheConf);
        HRegionFileSystem splitBregionFS = HRegionFileSystem.create((Configuration)conf, (FileSystem)fs, (Path)new Path(root_dir), (RegionInfo)splitBHri);
        StoreContext splitBStoreContext = StoreContext.getBuilder().withColumnFamilyDescriptor(ColumnFamilyDescriptorBuilder.of((String)"CF")).withFamilyStoreDirectoryPath(splitBPath).withRegionFileSystem(splitBregionFS).build();
        StoreFileTracker splitBsft = StoreFileTrackerFactory.create((Configuration)conf, (boolean)false, (StoreContext)splitBStoreContext);
        Reference top = new Reference(midkey, Reference.Range.top);
        splitBsft.createReference(top, splitFileB);
        this.doTestOfScanAndReseek(splitFileB, fs, top, cacheConf);
        r.close();
    }

    private void doTestOfScanAndReseek(Path p, FileSystem fs, Reference bottom, CacheConfig cacheConf) throws IOException {
        Cell curr;
        Path referencePath = StoreFileInfo.getReferredToFile((Path)p);
        FSDataInputStreamWrapper in = new FSDataInputStreamWrapper(fs, referencePath, false, 0L);
        FileStatus status = fs.getFileStatus(referencePath);
        long length = status.getLen();
        ReaderContextBuilder contextBuilder = new ReaderContextBuilder().withInputStreamWrapper(in).withFileSize(length).withReaderType(ReaderContext.ReaderType.PREAD).withFileSystem(fs).withFilePath(p);
        ReaderContext context = contextBuilder.build();
        StoreFileInfo storeFileInfo = new StoreFileInfo(TEST_UTIL.getConfiguration(), fs, fs.getFileStatus(p), bottom);
        storeFileInfo.initHFileInfo(context);
        HalfStoreFileReader halfreader = (HalfStoreFileReader)storeFileInfo.createReader(context, cacheConf);
        storeFileInfo.getHFileInfo().initMetaAndIndex(halfreader.getHFileReader());
        halfreader.loadFileInfo();
        HFileScanner scanner = halfreader.getScanner(false, false);
        scanner.seekTo();
        do {
            curr = scanner.getCell();
            KeyValue reseekKv = this.getLastOnCol(curr);
            int ret = scanner.reseekTo((Cell)reseekKv);
            Assert.assertTrue((String)("reseek to returned: " + ret), (ret > 0 ? 1 : 0) != 0);
        } while (scanner.next());
        int ret = scanner.reseekTo((Cell)this.getLastOnCol(curr));
        Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
        halfreader.close(true);
    }

    @Test
    public void testHalfScanner() throws IOException {
        String root_dir = TEST_UTIL.getDataTestDir().toString();
        Path p = new Path(root_dir, "test");
        Configuration conf = TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(1024).build();
        HFile.Writer w = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, p).withFileContext(meta).create();
        List<KeyValue> items = this.genSomeKeys();
        for (KeyValue kv : items) {
            w.append((Cell)kv);
        }
        w.close();
        HFile.Reader r = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        Cell midKV = (Cell)r.midKey().get();
        byte[] midkey = CellUtil.cloneRow((Cell)midKV);
        Reference bottom = new Reference(midkey, Reference.Range.bottom);
        Reference top = new Reference(midkey, Reference.Range.top);
        KeyValue beforeMidKey = null;
        for (KeyValue item : items) {
            if (CellComparatorImpl.COMPARATOR.compare((Cell)item, midKV) >= 0) break;
            beforeMidKey = item;
        }
        System.out.println("midkey: " + midKV + " or: " + Bytes.toStringBinary((byte[])midkey));
        System.out.println("beforeMidKey: " + beforeMidKey);
        Cell foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, midKV, cacheConf);
        Assert.assertEquals((Object)beforeMidKey, (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, (Cell)items.get(items.size() - 1), cacheConf);
        Assert.assertEquals((Object)items.get(items.size() - 2), (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, (Cell)items.get(items.size() - 1), cacheConf);
        Assert.assertEquals((Object)beforeMidKey, (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, (Cell)items.get(0), cacheConf);
        Assert.assertNull((Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, (Cell)items.get(0), cacheConf);
        Assert.assertNull((Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, (Cell)items.get(1), cacheConf);
        Assert.assertNull((Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, (Cell)items.get(1), cacheConf);
        Assert.assertEquals((Object)items.get(0), (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, midKV, cacheConf);
        Assert.assertNull((Object)foundKeyValue);
    }

    private Cell doTestOfSeekBefore(Path p, FileSystem fs, Reference bottom, Cell seekBefore, CacheConfig cacheConfig) throws IOException {
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, p).build();
        StoreFileInfo storeFileInfo = new StoreFileInfo(TEST_UTIL.getConfiguration(), fs, fs.getFileStatus(p), bottom);
        storeFileInfo.initHFileInfo(context);
        HalfStoreFileReader halfreader = (HalfStoreFileReader)storeFileInfo.createReader(context, cacheConfig);
        storeFileInfo.getHFileInfo().initMetaAndIndex(halfreader.getHFileReader());
        halfreader.loadFileInfo();
        HFileScanner scanner = halfreader.getScanner(false, false);
        scanner.seekBefore(seekBefore);
        return scanner.getCell();
    }

    private KeyValue getLastOnCol(Cell curr) {
        return KeyValueUtil.createLastOnRow((byte[])curr.getRowArray(), (int)curr.getRowOffset(), (int)curr.getRowLength(), (byte[])curr.getFamilyArray(), (int)curr.getFamilyOffset(), (int)curr.getFamilyLength(), (byte[])curr.getQualifierArray(), (int)curr.getQualifierOffset(), (int)curr.getQualifierLength());
    }

    static byte[] _b(String s) {
        return Bytes.toBytes((String)s);
    }

    List<KeyValue> genSomeKeys() {
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>(1000);
        for (int i = 0; i < 1000; ++i) {
            KeyValue kv = new KeyValue(TestHalfStoreFileReader._b(String.format("row_%04d", i)), TestHalfStoreFileReader._b("family"), TestHalfStoreFileReader._b("qualifier"), 1000L, TestHalfStoreFileReader._b("value"));
            ret.add(kv);
        }
        return ret;
    }
}

