/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.ClientPushbackTestBase;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestClientPushback
extends ClientPushbackTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientPushback.class);
    private ConnectionImplementation conn;
    private BufferedMutatorImpl mutator;

    @Before
    public void setUp() throws IOException {
        this.conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
        this.mutator = (BufferedMutatorImpl)this.conn.getBufferedMutator(tableName);
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.mutator, (boolean)true);
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    @Override
    protected ClientBackoffPolicy getBackoffPolicy() throws IOException {
        return this.conn.getBackoffPolicy();
    }

    @Override
    protected ServerStatisticTracker getStatisticsTracker() throws IOException {
        return this.conn.getStatisticsTracker();
    }

    @Override
    protected MetricsConnection getConnectionMetrics() throws IOException {
        return this.conn.getConnectionMetrics();
    }

    @Override
    protected void mutate(Put put) throws IOException {
        this.mutator.mutate((Mutation)put);
        this.mutator.flush();
    }

    @Override
    protected void mutate(Put put, AtomicLong endTime, CountDownLatch latch) throws IOException {
        ArrayList<Put> ops = new ArrayList<Put>(1);
        ops.add(put);
        Batch.Callback callback = (r, row, result) -> {
            endTime.set(EnvironmentEdgeManager.currentTime());
            latch.countDown();
        };
        AsyncProcessTask task = AsyncProcessTask.newBuilder((Batch.Callback)callback).setPool(this.mutator.getPool()).setTableName(tableName).setRowAccess(ops).setSubmittedRows(AsyncProcessTask.SubmittedRows.AT_LEAST_ONE).setOperationTimeout(this.conn.getConnectionConfiguration().getOperationTimeout()).setRpcTimeout(60000).build();
        this.mutator.getAsyncProcess().submit(task);
    }

    @Override
    protected void mutateRow(RowMutations mutations) throws IOException {
        try (Table table = this.conn.getTable(tableName);){
            table.mutateRow(mutations);
        }
    }
}

