/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncNonMetaRegionLocatorConcurrenyLimit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncNonMetaRegionLocatorConcurrenyLimit.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static AsyncConnectionImpl CONN;
    private static AsyncNonMetaRegionLocator LOCATOR;
    private static byte[][] SPLIT_KEYS;
    private static int MAX_ALLOWED;
    private static AtomicInteger CONCURRENCY;
    private static AtomicInteger MAX_CONCURRENCY;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", CountingRegionObserver.class.getName());
        conf.setInt("hbase.client.meta.max.concurrent.locate.per.table", MAX_ALLOWED);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration(), (User)User.getCurrent());
        CONN = new AsyncConnectionImpl(TEST_UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent());
        LOCATOR = new AsyncNonMetaRegionLocator(CONN);
        SPLIT_KEYS = (byte[][])IntStream.range(1, 256).mapToObj(i -> Bytes.toBytes((String)String.format("%02x", i))).toArray(x$0 -> new byte[x$0][]);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, SPLIT_KEYS);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    private void assertLocs(List<CompletableFuture<RegionLocations>> futures) throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)256L, (long)futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            HRegionLocation loc = futures.get(i).get().getDefaultRegionLocation();
            if (i == 0) {
                Assert.assertTrue((boolean)ConnectionUtils.isEmptyStartRow((byte[])loc.getRegion().getStartKey()));
            } else {
                Assert.assertEquals((Object)String.format("%02x", i), (Object)Bytes.toString((byte[])loc.getRegion().getStartKey()));
            }
            if (i == futures.size() - 1) {
                Assert.assertTrue((boolean)ConnectionUtils.isEmptyStopRow((byte[])loc.getRegion().getEndKey()));
                continue;
            }
            Assert.assertEquals((Object)String.format("%02x", i + 1), (Object)Bytes.toString((byte[])loc.getRegion().getEndKey()));
        }
    }

    @Test
    public void test() throws InterruptedException, ExecutionException {
        List<CompletableFuture<RegionLocations>> futures = IntStream.range(0, 256).mapToObj(i -> Bytes.toBytes((String)String.format("%02x", i))).map(r -> LOCATOR.getRegionLocations(TABLE_NAME, r, 0, RegionLocateType.CURRENT, false)).collect(Collectors.toList());
        this.assertLocs(futures);
        Assert.assertTrue((String)("max allowed is " + MAX_ALLOWED + " but actual is " + MAX_CONCURRENCY.get()), (MAX_CONCURRENCY.get() <= MAX_ALLOWED ? 1 : 0) != 0);
    }

    static {
        MAX_ALLOWED = 2;
        CONCURRENCY = new AtomicInteger(0);
        MAX_CONCURRENCY = new AtomicInteger(0);
    }

    public static final class CountingRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
            if (((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().isMetaRegion()) {
                int max;
                int concurrency = CONCURRENCY.incrementAndGet();
                while (concurrency > (max = MAX_CONCURRENCY.get()) && !MAX_CONCURRENCY.compareAndSet(max, concurrency)) {
                }
                Threads.sleepWithoutInterrupt((long)10L);
            }
            return hasNext;
        }

        public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
            if (((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().isMetaRegion()) {
                CONCURRENCY.decrementAndGet();
            }
            return hasNext;
        }
    }
}

