/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.InternalUtil;
import org.apache.directory.mavibot.btree.Leaf;
import org.apache.directory.mavibot.btree.Node;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.Transaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

public class Cursor<K, V> {
    private Transaction<K, V> transaction;
    private Tuple<K, V> tuple = new Tuple();
    private LinkedList<ParentPos<K, V>> stack;
    private BTree<K, V> btree;
    private boolean allowDuplicates;
    private LinkedList<ParentPos<K, V>> _initialStack;

    Cursor(BTree<K, V> btree, Transaction<K, V> transaction, LinkedList<ParentPos<K, V>> stack) {
        this.transaction = transaction;
        this.stack = stack;
        this.btree = btree;
        this.allowDuplicates = btree.isAllowDuplicates();
        this._initialStack = new LinkedList();
        this.cloneStack(stack, this._initialStack);
    }

    public Tuple<K, V> next() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos = this.stack.getFirst();
        if (parentPos.page == null) {
            throw new NoSuchElementException("No more tuples present");
        }
        if (parentPos.pos == parentPos.page.getNbElems()) {
            parentPos = this.findNextParentPos();
            if (parentPos.page == null || parentPos.page instanceof Node) {
                throw new NoSuchElementException("No more tuples present");
            }
        }
        if (parentPos.pos < 0) {
            parentPos.pos = 0;
        }
        Leaf leaf = (Leaf)parentPos.page;
        this.tuple.setKey(leaf.keys[parentPos.pos]);
        if (this.allowDuplicates) {
            InternalUtil.setDupsContainer(parentPos, this.btree);
            if (parentPos.dupPos < 0) {
                parentPos.dupPos = 0;
            }
            this.tuple.setValue(parentPos.dupsContainer.rootPage.getKey(parentPos.dupPos));
            ++parentPos.dupPos;
            if (parentPos.dupsContainer.getNbElems() == (long)parentPos.dupPos) {
                ++parentPos.pos;
                InternalUtil.changeNextDupsContainer(parentPos, this.btree);
            }
        } else {
            this.tuple.setValue(leaf.values[parentPos.pos].getValue(this.btree));
            ++parentPos.pos;
        }
        return this.tuple;
    }

    private ParentPos<K, V> findNextParentPos() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos;
        ParentPos<K, V> lastParentPos = null;
        while (true) {
            if ((parentPos = this.stack.peek()) == null) {
                this.stack.push(lastParentPos);
                return lastParentPos;
            }
            if (parentPos.pos != parentPos.page.getNbElems()) break;
            lastParentPos = this.stack.pop();
        }
        int newPos = ++parentPos.pos;
        ParentPos<K, V> newParentPos = parentPos;
        while (newParentPos.page instanceof Node) {
            Node node = (Node)newParentPos.page;
            newParentPos = new ParentPos(node.children[newPos].getValue(this.btree), 0);
            this.stack.push(newParentPos);
            newPos = 0;
        }
        if (this.allowDuplicates) {
            InternalUtil.changeNextDupsContainer(newParentPos, this.btree);
        }
        return newParentPos;
    }

    private ParentPos<K, V> findPreviousParentPos() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos;
        ParentPos<K, V> lastParentPos = null;
        while (true) {
            if ((parentPos = this.stack.peek()) == null) {
                this.stack.push(lastParentPos);
                return lastParentPos;
            }
            if (parentPos.pos != 0) break;
            lastParentPos = this.stack.pop();
        }
        int newPos = --parentPos.pos;
        ParentPos<K, V> newParentPos = parentPos;
        while (newParentPos.page instanceof Node) {
            Node node = (Node)newParentPos.page;
            newParentPos = new ParentPos(node.children[newPos].getValue(this.btree), node.children[newPos].getValue(this.btree).getNbElems());
            this.stack.push(newParentPos);
            newPos = node.getNbElems();
        }
        if (this.allowDuplicates) {
            InternalUtil.changePrevDupsContainer(newParentPos, this.btree);
        }
        return newParentPos;
    }

    public Tuple<K, V> prev() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos = this.stack.peek();
        if (parentPos.page == null) {
            throw new NoSuchElementException("No more tuples present");
        }
        if (parentPos.pos == 0 && parentPos.dupPos == 0) {
            parentPos = this.findPreviousParentPos();
            if (parentPos.page == null || parentPos.page instanceof Node) {
                throw new NoSuchElementException("No more tuples present");
            }
        }
        Leaf leaf = (Leaf)parentPos.page;
        if (this.allowDuplicates) {
            InternalUtil.setDupsContainer(parentPos, this.btree);
            if (parentPos.pos == parentPos.page.getNbElems()) {
                --parentPos.pos;
            }
            if ((long)parentPos.dupPos == parentPos.dupsContainer.getNbElems()) {
                --parentPos.dupPos;
            } else if (parentPos.dupPos == 0) {
                InternalUtil.changePrevDupsContainer(parentPos, this.btree);
                --parentPos.pos;
                --parentPos.dupPos;
            } else {
                --parentPos.dupPos;
            }
            this.tuple.setKey(leaf.keys[parentPos.pos]);
            this.tuple.setValue(parentPos.dupsContainer.rootPage.getKey(parentPos.dupPos));
        } else {
            --parentPos.pos;
            this.tuple.setKey(leaf.keys[parentPos.pos]);
            this.tuple.setValue(leaf.values[parentPos.pos].getValue(this.btree));
        }
        return this.tuple;
    }

    public boolean hasNext() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos = this.stack.peek();
        if (parentPos.page == null) {
            return false;
        }
        for (ParentPos parentPos2 : this.stack) {
            if (!(this.allowDuplicates && parentPos2.page instanceof Leaf ? (long)parentPos2.dupPos != parentPos2.dupsContainer.getNbElems() && parentPos2.pos != parentPos2.page.getNbElems() : parentPos2.pos != parentPos2.page.getNbElems())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrev() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos = this.stack.peek();
        if (parentPos.page == null) {
            return false;
        }
        for (ParentPos parentPos2 : this.stack) {
            if (!(this.allowDuplicates && parentPos2.page instanceof Leaf ? parentPos2.dupPos != 0 || parentPos2.pos != 0 : parentPos2.pos != 0)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        this.transaction.close();
    }

    public long getRevision() {
        return this.transaction.getRevision();
    }

    public long getCreationDate() {
        return this.transaction.getCreationDate();
    }

    public void moveToNextNonDuplicateKey() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos = this.stack.getFirst();
        if (parentPos.page == null) {
            return;
        }
        if (parentPos.pos == parentPos.page.getNbElems() - 1) {
            ++parentPos.pos;
            ParentPos<K, V> nextPos = this.findNextParentPos();
            if (nextPos.page instanceof Node || nextPos == parentPos) {
                this.afterLast();
            } else {
                parentPos = nextPos;
            }
        } else {
            ++parentPos.pos;
            InternalUtil.changeNextDupsContainer(parentPos, this.btree);
        }
    }

    public void moveToPrevNonDuplicateKey() throws EndOfFileExceededException, IOException {
        ParentPos<K, V> parentPos = this.stack.peek();
        if (parentPos.page == null) {
            return;
        }
        if (parentPos.pos == 0) {
            parentPos = this.findPreviousParentPos();
            if (parentPos.page instanceof Node) {
                this.beforeFirst();
            }
        } else {
            InternalUtil.changePrevDupsContainer(parentPos, this.btree);
            --parentPos.pos;
        }
    }

    public void beforeFirst() throws IOException {
        this.cloneStack(this._initialStack, this.stack);
    }

    public void afterLast() throws IOException {
        this.stack.clear();
        this.stack = BTreeFactory.getPathToRightMostLeaf(this.btree);
    }

    private void cloneStack(LinkedList<ParentPos<K, V>> original, LinkedList<ParentPos<K, V>> clone) {
        clone.clear();
        for (ParentPos parentPos : original) {
            ParentPos tmp = new ParentPos(parentPos.page, parentPos.pos);
            tmp.dupPos = parentPos.dupPos;
            tmp.dupsContainer = parentPos.dupsContainer;
            clone.add(tmp);
        }
    }
}

